/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.platform.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.SystemUtils;
import org.geoserver.platform.resource.FilePaths;
import org.geoserver.platform.resource.Paths;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.ResourceMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.experimental.theories.Theories;
import org.junit.experimental.theories.Theory;
import org.junit.runner.RunWith;

@RunWith(value=Theories.class)
public abstract class ResourceTheoryTest {
    protected abstract Resource getResource(String var1) throws Exception;

    protected abstract Resource getDirectory();

    protected abstract Resource getResource();

    protected abstract Resource getUndefined();

    @Theory
    public void theoryNotNull(String path) throws Exception {
        Resource res = this.getResource(path);
        MatcherAssert.assertThat((Object)res, (Matcher)Matchers.notNullValue());
    }

    @Theory
    public void theoryExtantHaveDate(String path) throws Exception {
        Resource res = this.getResource(path);
        Assume.assumeThat((Object)res, ResourceMatchers.defined());
        long result = res.lastmodified();
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
    }

    @Theory
    public void theoryHaveSamePath(String path) throws Exception {
        Resource res = this.getResource(path);
        String result = res.path();
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)path)));
    }

    @Theory
    public void theoryHaveName(String path) throws Exception {
        Resource res = this.getResource(path);
        String result = res.name();
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
    }

    @Theory
    public void theoryNameIsEndOfPath(String path) throws Exception {
        Resource res = this.getResource(path);
        List elements = Paths.names((String)path);
        String lastElement = (String)elements.get(elements.size() - 1);
        String result = res.name();
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.equalTo((Object)lastElement));
    }

    @Theory
    public void theoryLeavesHaveIstream(String path) throws Exception {
        Resource res = this.getResource(path);
        Assume.assumeThat((Object)res, (Matcher)Matchers.is(ResourceMatchers.resource()));
        try (InputStream result = res.in();){
            MatcherAssert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
        }
    }

    @Theory
    public void theoryLeavesHaveOstream(String path) throws Exception {
        Resource res = this.getResource(path);
        Assume.assumeThat((Object)res, (Matcher)Matchers.is(ResourceMatchers.resource()));
        try (OutputStream result = res.out();){
            MatcherAssert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
        }
    }

    @Theory
    public void theoryUndefinedHaveNoIstreams(String path) throws Exception {
        Resource res = this.getResource(path);
        Assume.assumeThat((Object)res, (Matcher)Matchers.is(ResourceMatchers.undefined()));
        Assert.assertThrows(IllegalStateException.class, () -> res.in().close());
        MatcherAssert.assertThat((Object)res, (Matcher)Matchers.is(ResourceMatchers.undefined()));
    }

    @Theory
    public void theoryUndefinedHaveOstreamAndBecomeResource(String path) throws Exception {
        Resource res = this.getResource(path);
        Assume.assumeThat((Object)res, (Matcher)Matchers.is(ResourceMatchers.undefined()));
        try (OutputStream result = res.out();){
            MatcherAssert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((Object)res, (Matcher)Matchers.is(ResourceMatchers.resource()));
        }
    }

    @Theory
    public void theoryNonDirectoriesPersistData(String path) throws Exception {
        Resource res = this.getResource(path);
        Assume.assumeThat((Object)res, (Matcher)Matchers.not(ResourceMatchers.directory()));
        byte[] test = new byte[]{42, 29, 32, 120, 69, 0, 1};
        try (OutputStream ostream = res.out();){
            ostream.write(test);
        }
        byte[] result = new byte[test.length];
        try (InputStream istream = res.in();){
            istream.read(result);
            MatcherAssert.assertThat((Object)istream.read(), (Matcher)Matchers.is((Object)-1));
        }
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.equalTo((Object)test));
    }

    @Theory
    public void theoryDirectoriesHaveNoIstreams(String path) throws Exception {
        Resource res = this.getResource(path);
        Assume.assumeThat((Object)res, (Matcher)Matchers.is(ResourceMatchers.directory()));
        Assert.assertThrows(IllegalStateException.class, () -> res.in().close());
    }

    @Theory
    public void theoryDirectoriesHaveNoOstream(String path) throws Exception {
        Resource res = this.getResource(path);
        Assume.assumeThat((Object)res, (Matcher)Matchers.is(ResourceMatchers.directory()));
        Assert.assertThrows(IllegalStateException.class, () -> res.out().close());
    }

    @Theory
    public void theoryLeavesHaveEmptyListOfChildren(String path) throws Exception {
        Resource res = this.getResource(path);
        Assume.assumeThat((Object)res, (Matcher)Matchers.is(ResourceMatchers.resource()));
        List result = res.list();
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.empty());
    }

    @Theory
    public void theoryUndefinedHaveEmptyListOfChildren(String path) throws Exception {
        Resource res = this.getResource(path);
        Assume.assumeThat((Object)res, (Matcher)Matchers.is(ResourceMatchers.undefined()));
        List result = res.list();
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.empty());
    }

    @Theory
    public void theoryDirectoriesHaveChildren(String path) throws Exception {
        Resource res = this.getResource(path);
        Assume.assumeThat((Object)res, (Matcher)Matchers.is(ResourceMatchers.directory()));
        List result = res.list();
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
    }

    @Theory
    public void theoryChildrenKnowTheirParents(String path) throws Exception {
        Resource res = this.getResource(path);
        Assume.assumeThat((Object)res, (Matcher)Matchers.is(ResourceMatchers.directory()));
        List children = res.list();
        Assume.assumeThat((Object)children, (Matcher)Matchers.not((Matcher)Matchers.empty()));
        for (Resource child : children) {
            Resource parent = child.parent();
            MatcherAssert.assertThat((Object)parent, (Matcher)Matchers.equalTo((Object)res));
        }
    }

    @Theory
    public void theoryParentsKnowTheirChildren(String path) throws Exception {
        Resource res = this.getResource(path);
        Assume.assumeThat((Object)res, (Matcher)Matchers.is(ResourceMatchers.directory()));
        Resource parent = res.parent();
        Assume.assumeThat((String)path, (Object)parent, (Matcher)Matchers.notNullValue());
        List result = parent.list();
        MatcherAssert.assertThat((String)path, (Object)result, (Matcher)Matchers.hasItem((Object)res));
    }

    @Theory
    public void theorySamePathGivesEquivalentResource(String path) throws Exception {
        Resource res1 = this.getResource(path);
        Resource res2 = this.getResource(path);
        MatcherAssert.assertThat((Object)res2, (Matcher)Matchers.equalTo((Object)res1));
    }

    @Theory
    public void theoryParentIsDirectory(String path) throws Exception {
        Resource res = this.getResource(path);
        Resource parent = res.parent();
        Assume.assumeThat((String)(path + " not root"), (Object)parent, (Matcher)Matchers.notNullValue());
        if (res.getType() != Resource.Type.UNDEFINED) {
            MatcherAssert.assertThat((String)(path + " directory"), (Object)parent, (Matcher)Matchers.is(ResourceMatchers.directory()));
        }
    }

    @Theory
    public void theoryHaveFile(String path) throws Exception {
        Resource res = this.getResource(path);
        Assume.assumeThat((Object)res, ResourceMatchers.resource());
        File result = res.file();
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
    }

    @Theory
    public void theoryHaveDir(String path) throws Exception {
        Resource res = this.getResource(path);
        Assume.assumeThat((Object)res, ResourceMatchers.directory());
        File result = res.dir();
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
    }

    @Theory
    public void theoryDeletedResourcesAreUndefined(String path) throws Exception {
        Resource res = this.getResource(path);
        Assume.assumeThat((Object)res, ResourceMatchers.resource());
        MatcherAssert.assertThat((Object)res.delete(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)res, ResourceMatchers.undefined());
    }

    @Theory
    public void theoryUndefinedNotDeleted(String path) throws Exception {
        Resource res = this.getResource(path);
        Assume.assumeThat((Object)res, ResourceMatchers.undefined());
        MatcherAssert.assertThat((Object)res.delete(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)res, ResourceMatchers.undefined());
    }

    @Theory
    public void theoryRenamedAreUndefined(String path) throws Exception {
        Resource res = this.getResource(path);
        Assume.assumeThat((Object)res, ResourceMatchers.defined());
        Resource target = this.getUndefined();
        MatcherAssert.assertThat((Object)res.renameTo(target), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)res, ResourceMatchers.undefined());
    }

    @Theory
    public void theoryRenamedResourcesAreEquivalent(String path) throws Exception {
        byte[] resultContent;
        byte[] expectedContent;
        Resource res = this.getResource(path);
        Assume.assumeThat((Object)res, ResourceMatchers.resource());
        try (InputStream in = res.in();){
            expectedContent = IOUtils.toByteArray((InputStream)in);
        }
        Resource target = this.getUndefined();
        MatcherAssert.assertThat((Object)res.renameTo(target), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)target, ResourceMatchers.resource());
        try (InputStream in = target.in();){
            resultContent = IOUtils.toByteArray((InputStream)in);
        }
        MatcherAssert.assertThat((Object)resultContent, (Matcher)Matchers.equalTo((Object)expectedContent));
    }

    @Theory
    public void theoryNonDirectoriesHaveFileWithSameContents(String path) throws Exception {
        Resource res = this.getResource(path);
        Assume.assumeThat((Object)res, (Matcher)Matchers.not(ResourceMatchers.directory()));
        byte[] test = new byte[]{42, 29, 32, 120, 69, 0, 1};
        try (OutputStream ostream = res.out();){
            ostream.write(test);
        }
        byte[] result = new byte[test.length];
        try (FileInputStream istream = new FileInputStream(res.file());){
            ((InputStream)istream).read(result);
            MatcherAssert.assertThat((Object)((InputStream)istream).read(), (Matcher)Matchers.is((Object)-1));
        }
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.equalTo((Object)test));
    }

    @Theory
    public void theoryDirectoriesHaveFileWithSameNamedChildren(String path) throws Exception {
        Resource res = this.getResource(path);
        Assume.assumeThat((Object)res, (Matcher)Matchers.is(ResourceMatchers.directory()));
        File dir = res.dir();
        List resChildren = res.list();
        String[] fileChildrenNames = dir.list();
        Object[] resChildrenNames = new String[resChildren.size()];
        int i = 0;
        for (Resource child : resChildren) {
            resChildrenNames[i] = child.name();
            ++i;
        }
        MatcherAssert.assertThat((Object)fileChildrenNames, (Matcher)Matchers.arrayContainingInAnyOrder((Object[])resChildrenNames));
    }

    @Theory
    public void theoryAlteringFileAltersResource(String path) throws Exception {
        Resource res = this.getResource(path);
        Assume.assumeThat((Object)res, (Matcher)Matchers.not(ResourceMatchers.directory()));
        byte[] testResource = new byte[]{42, 29, 32, 120, 69, 0, 1};
        byte[] testFile = new byte[]{27, 3, 5, 90, -120, -3};
        try (OutputStream ostream = res.out();){
            ostream.write(testResource);
        }
        ostream = new FileOutputStream(res.file());
        try {
            ostream.write(testFile);
        }
        finally {
            ostream.close();
        }
        byte[] result = new byte[testFile.length];
        try (InputStream istream = res.in();){
            istream.read(result);
            MatcherAssert.assertThat((Object)istream.read(), (Matcher)Matchers.is((Object)-1));
        }
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.equalTo((Object)testFile));
    }

    @Theory
    public void theoryAddingFileToDirectoryAddsResource(String path) throws Exception {
        Resource res = this.getResource(path);
        Assume.assumeThat((Object)res, (Matcher)Matchers.is(ResourceMatchers.directory()));
        File dir = res.dir();
        File file = new File(dir, "newFileCreatedDirectly");
        Assume.assumeTrue((boolean)file.createNewFile());
        Resource child = this.getResource(Paths.path((String[])new String[]{res.name(), "newFileCreatedDirectly"}));
        List children = res.list();
        MatcherAssert.assertThat((Object)child, (Matcher)Matchers.is(ResourceMatchers.defined()));
        MatcherAssert.assertThat((Object)children, (Matcher)Matchers.hasItem((Object)child));
    }

    @Theory
    public void theoryMultipleOutputStreamsAreSafe(String path) throws Exception {
        byte[] resultContent;
        Resource res = this.getResource(path);
        Assume.assumeThat((Object)res, (Matcher)Matchers.is(ResourceMatchers.resource()));
        byte[] thread1Content = "This is the content for thread 1".getBytes();
        byte[] thread2Content = "Thread 2 has this content".getBytes();
        try (OutputStream out1 = res.out();
             OutputStream out2 = res.out();){
            for (int i = 0; i < thread1Content.length || i < thread2Content.length; ++i) {
                if (i < thread1Content.length) {
                    out1.write(thread1Content[i]);
                }
                if (i >= thread2Content.length) continue;
                out2.write(thread2Content[i]);
            }
        }
        try (InputStream in = res.in();){
            resultContent = IOUtils.toByteArray((InputStream)in);
        }
        MatcherAssert.assertThat((Object)resultContent, (Matcher)Matchers.anyOf((Matcher)Matchers.equalTo((Object)thread1Content), (Matcher)Matchers.equalTo((Object)thread2Content)));
    }

    @Theory
    public void theoryDoubleClose(String path) throws Exception {
        Resource res = this.getResource(path);
        Assume.assumeThat((Object)res, (Matcher)Matchers.is(ResourceMatchers.resource()));
        OutputStream os = res.out();
        os.close();
        os.close();
    }

    @Theory
    public void theoryRecursiveDelete(String path) throws Exception {
        Resource res = this.getResource(path);
        Assume.assumeThat((Object)res, (Matcher)Matchers.is(ResourceMatchers.directory()));
        Assume.assumeThat((Object)res, (Matcher)Matchers.is(ResourceMatchers.directory()));
        List result = res.list();
        Assume.assumeThat((Object)result.size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        Assert.assertTrue((boolean)res.delete());
    }

    public void theoryNoAbsoluteFiles(String path) throws Exception {
        File home = new File(System.getProperty("user.home")).getCanonicalFile();
        File file = new File(home, path);
        Resource res = this.getResource(Paths.convert((String)file.getPath()));
        Assert.assertFalse((boolean)FilePaths.isAbsolute((String)res.path()));
    }

    @Theory
    public void theoryObsoleteSlashIsIgnored(String path) throws Exception {
        Resource res = this.getResource(path);
        Resource res2 = this.getResource("/" + path);
        Resource res3 = this.getResource(path + "/");
        Assert.assertEquals((Object)res, (Object)res2);
        Assert.assertEquals((Object)res.path(), (Object)res2.path());
        Assert.assertEquals((Object)res, (Object)res3);
        Assert.assertEquals((Object)res.path(), (Object)res3.path());
    }

    @Test
    public void testPathTraversal() {
        this.assertInvalidPath("..");
        this.assertInvalidPath("../foo/bar");
        this.assertInvalidPath("foo/../bar");
        this.assertInvalidPath("foo/bar/..");
    }

    @Test
    public void testPathTraversalWindows() {
        Assume.assumeTrue((boolean)SystemUtils.IS_OS_WINDOWS);
        this.assertInvalidPath("..\\foo\\bar");
        this.assertInvalidPath("foo\\..\\bar");
        this.assertInvalidPath("foo\\bar\\..");
    }

    protected final void assertInvalidPath(String path) {
        Assert.assertThrows(IllegalArgumentException.class, () -> this.getResource(path));
    }
}

