/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.platform.resource;

import java.io.File;
import java.io.IOException;
import org.geoserver.platform.resource.FilePaths;
import org.geoserver.platform.resource.Files;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.ResourceTheoryTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.experimental.theories.DataPoints;
import org.junit.rules.TemporaryFolder;

public class FileWrapperResourceTheoryTest
extends ResourceTheoryTest {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();

    @DataPoints
    public static String[] getTestPaths() {
        return new String[]{"FileA", "FileB", "DirC", "DirE", "DirC/FileD", "UndefF", "DirC/UndefF", "DirE/UndefF"};
    }

    @Override
    protected Resource getResource(String path) throws Exception {
        File file = FilePaths.toFile((File)this.folder.getRoot(), (String)path);
        return Files.asResource((File)file);
    }

    @Before
    public void setUp() throws Exception {
        this.folder.newFile("FileA");
        this.folder.newFile("FileB");
        File c = this.folder.newFolder("DirC");
        new File(c, "FileD").createNewFile();
        this.folder.newFolder("DirE");
    }

    @Override
    protected Resource getDirectory() {
        try {
            return Files.asResource((File)this.folder.newFolder("NonTestDir"));
        }
        catch (IOException e) {
            Assert.fail();
            return null;
        }
    }

    @Override
    protected Resource getResource() {
        try {
            return Files.asResource((File)this.folder.newFile("NonTestFile"));
        }
        catch (IOException e) {
            Assert.fail();
            return null;
        }
    }

    @Override
    protected Resource getUndefined() {
        return Files.asResource((File)new File(this.folder.getRoot(), "NonTestUndef"));
    }

    @Override
    @Ignore
    public void theoryHaveSamePath(String path) throws Exception {
    }
}

