/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.platform.resource;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.geoserver.platform.resource.FileSystemResourceStore;
import org.geoserver.platform.resource.FileSystemWatcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class FileSystemResourceStoreTest {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();
    private FileSystemResourceStore store;

    @Before
    public void before() {
        this.store = new FileSystemResourceStore(this.folder.getRoot());
    }

    @Test
    public void renameSameFileName() throws IOException, InterruptedException {
        String sameName = "Filea";
        this.attemptRenameFile(sameName, sameName);
        Assert.assertEquals((Object)sameName, (Object)this.folder.getRoot().list()[0]);
    }

    @Test
    public void renameFileNamesCaseDiffer() throws IOException, InterruptedException {
        String newName = "Filea";
        this.attemptRenameFile("FileA", newName);
        Assert.assertEquals((Object)newName, (Object)this.folder.getRoot().list()[0]);
    }

    @Test
    public void renameFileNamesDiffer() throws IOException, InterruptedException {
        String newName = "FileB";
        this.attemptRenameFile("FileA", newName);
        Assert.assertEquals((Object)newName, (Object)this.folder.getRoot().list()[0]);
    }

    @Test
    public void renameSameDirName() throws IOException, InterruptedException {
        String sameName = "Dira";
        this.attemptRenameDir(sameName, sameName);
        Assert.assertEquals((Object)sameName, (Object)this.folder.getRoot().list()[0]);
    }

    @Test
    public void renameDirNamesCaseDiffer() throws IOException, InterruptedException {
        String newName = "Dira";
        this.attemptRenameDir("DirA", newName);
        Assert.assertEquals((Object)newName, (Object)this.folder.getRoot().list()[0]);
    }

    @Test
    public void renameDirNamesDiffer() throws IOException, InterruptedException {
        String newName = "DirB";
        this.attemptRenameDir("DirA", newName);
        Assert.assertEquals((Object)newName, (Object)this.folder.getRoot().list()[0]);
    }

    private void attemptRenameDir(String oldName, String newName) throws IOException {
        this.folder.newFolder(oldName);
        this.attemptRename(oldName, newName);
    }

    private void attemptRenameFile(String oldName, String newName) throws IOException {
        this.folder.newFile(oldName);
        this.attemptRename(oldName, newName);
    }

    private void attemptRename(String oldName, String newName) throws IOException {
        Assert.assertEquals((long)1L, (long)this.folder.getRoot().list().length);
        this.store.move(oldName, newName);
        Assert.assertEquals((long)1L, (long)this.folder.getRoot().list().length);
    }

    @Test
    public void testGetResourceNotificationDispatcher_AtomicLazyInitialization() {
        int nThreads = 64;
        int nTasks = 256;
        ExecutorService executorService = Executors.newFixedThreadPool(64);
        try {
            Collection tasks = IntStream.range(0, 256).mapToObj(i -> () -> (FileSystemWatcher)this.store.getResourceNotificationDispatcher()).collect(Collectors.toList());
            List watchers = executorService.invokeAll(tasks).stream().map(completedFuture -> {
                try {
                    return (FileSystemWatcher)completedFuture.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }).collect(Collectors.toList());
            Assert.assertEquals((long)256L, (long)watchers.size());
            Assert.assertEquals((String)"FileSystemWatcher initialization wasn't lazy and atomic", (long)1L, (long)new HashSet(watchers).size());
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            executorService.shutdownNow();
        }
    }
}

