/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.platform;

import java.util.List;
import org.easymock.EasyMock;
import org.geoserver.platform.ExtensionFilter;
import org.geoserver.platform.ExtensionProvider;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.ModuleStatus;
import org.geoserver.platform.ModuleStatusImpl;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.context.ApplicationContext;

public class ModuleStatusTest {
    @Test
    public void testModuleStatus() {
        ModuleStatus status = (ModuleStatus)EasyMock.createMock((String)"testStatus", ModuleStatus.class);
        EasyMock.expect((Object)status.getName()).andReturn((Object)"test").atLeastOnce();
        ModuleStatusImpl impl = new ModuleStatusImpl();
        impl.setName("default");
        ApplicationContext appContext = (ApplicationContext)EasyMock.createMock(ApplicationContext.class);
        EasyMock.expect((Object)appContext.getBean("testStatus")).andStubReturn((Object)status);
        EasyMock.expect((Object)appContext.getBean("defaultStatus")).andStubReturn((Object)impl);
        GeoServerExtensions gse = new GeoServerExtensions();
        gse.setApplicationContext(appContext);
        EasyMock.expect((Object)appContext.getBeanNamesForType(ExtensionFilter.class)).andReturn((Object)new String[0]);
        EasyMock.expect((Object)appContext.getBeanNamesForType(ModuleStatus.class)).andStubReturn((Object)new String[]{"testStatus", "defaultStatus"});
        EasyMock.expect((Object)appContext.isSingleton((String)EasyMock.anyObject())).andReturn((Object)true).anyTimes();
        EasyMock.expect((Object)appContext.getBeanNamesForType(ExtensionProvider.class)).andReturn((Object)new String[0]);
        EasyMock.replay((Object[])new Object[]{status, appContext});
        List list = GeoServerExtensions.extensions(ModuleStatus.class);
        Assert.assertEquals((String)"test interfact mock", (Object)"test", (Object)status.getName());
        Assert.assertEquals((String)"found module status", (long)2L, (long)list.size());
        boolean foundDefault = false;
        boolean foundTest = false;
        for (ModuleStatus s : list) {
            if ("default".equals(s.getName())) {
                foundDefault = true;
            }
            if (!"test".equals(s.getName())) continue;
            foundTest = true;
        }
        Assert.assertTrue((boolean)foundDefault);
        Assert.assertTrue((boolean)foundTest);
        EasyMock.verify((Object[])new Object[]{status});
    }

    @Test
    public void testModuleStatusBooleans() {
        ModuleStatusImpl impl = new ModuleStatusImpl();
        impl.setAvailable(false);
        impl.setEnabled(false);
        Assert.assertFalse((boolean)impl.isAvailable());
        Assert.assertFalse((boolean)impl.isEnabled());
    }
}

