/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.platform.util;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.platform.GeoServerExtensions;
import org.geotools.util.logging.Logging;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public abstract class GeoServerPropertyFactoryBean<T>
extends AbstractFactoryBean<T>
implements ApplicationContextAware {
    private static final Logger LOGGER = Logging.getLogger(GeoServerPropertyFactoryBean.class);
    private ApplicationContext applicationContext;
    private final String propertyName;
    private String defaultValue;

    public GeoServerPropertyFactoryBean(String propertyName) {
        this.propertyName = propertyName;
    }

    protected T createInstance() throws Exception {
        String value = GeoServerExtensions.getProperty(this.propertyName, this.applicationContext);
        Object[] logParams = new Object[]{this.propertyName, value, this.getDefaultValue()};
        if (value == null || value.isEmpty()) {
            LOGGER.log(Level.INFO, "{0} was empty or undefined, using default \"{2}\" instead", logParams);
            return this.getDefaultBean();
        }
        T bean = this.createInstance(value);
        if (bean == null) {
            LOGGER.log(Level.WARNING, "{0} had unexpected value \"{1}\", using default \"{2}\" instead", logParams);
            bean = this.getDefaultBean();
        }
        return bean;
    }

    private T getDefaultBean() throws Exception {
        String value = this.getDefaultValue();
        if (value == null) {
            throw new IllegalStateException("No default value for " + this.propertyName);
        }
        T defaultBean = this.createInstance(value);
        if (defaultBean == null) {
            throw new IllegalStateException(this.propertyName + " default value \"" + value + "\" did not prduce a bean");
        }
        return defaultBean;
    }

    protected abstract T createInstance(String var1) throws Exception;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }
}

