/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.platform.resource;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.codec.digest.DigestUtils;
import org.geoserver.platform.resource.LockProvider;
import org.geoserver.platform.resource.Resource;
import org.geotools.util.logging.Logging;

public class MemoryLockProvider
implements LockProvider {
    static final Logger LOGGER = Logging.getLogger((String)MemoryLockProvider.class.getName());
    Lock[] locks;

    public MemoryLockProvider() {
        this(1024);
    }

    public MemoryLockProvider(int concurrency) {
        this.locks = new Lock[concurrency];
        for (int i = 0; i < this.locks.length; ++i) {
            this.locks[i] = new ReentrantLock();
        }
    }

    @Override
    public Resource.Lock acquire(final String lockKey) {
        final int idx = this.getIndex(lockKey);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Mapped lock key " + lockKey + " to index " + idx + ". Acquiring lock.");
        }
        this.locks[idx].lock();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Mapped lock key " + lockKey + " to index " + idx + ". Lock acquired");
        }
        return new Resource.Lock(){
            boolean released = false;

            @Override
            public void release() {
                if (!this.released) {
                    this.released = true;
                    MemoryLockProvider.this.locks[idx].unlock();
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Released lock key " + lockKey + " mapped to index " + idx);
                    }
                }
            }

            public String toString() {
                return "MemoryLock " + idx;
            }
        };
    }

    private int getIndex(String lockKey) {
        int idx = Math.abs(DigestUtils.sha1Hex((String)lockKey).hashCode() % this.locks.length);
        return idx;
    }

    public String toString() {
        return "MemoryLockProvider";
    }
}

