/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.platform;

import java.util.LinkedHashSet;
import java.util.Set;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.geoserver.platform.GeoServerExtensions;

public class GeoServerHttpSessionListenerProxy
implements HttpSessionListener {
    protected volatile Set<HttpSessionListener> listeners;

    public void sessionCreated(HttpSessionEvent se) {
        for (HttpSessionListener listener : this.listeners()) {
            listener.sessionCreated(se);
        }
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        for (HttpSessionListener listener : this.listeners()) {
            listener.sessionDestroyed(se);
        }
    }

    public boolean contains(HttpSessionListener listener) {
        return this.listeners.contains(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<HttpSessionListener> listeners() {
        if (this.listeners == null) {
            GeoServerHttpSessionListenerProxy geoServerHttpSessionListenerProxy = this;
            synchronized (geoServerHttpSessionListenerProxy) {
                if (this.listeners == null) {
                    this.listeners = new LinkedHashSet<HttpSessionListener>(GeoServerExtensions.extensions(HttpSessionListener.class));
                }
            }
        }
        return this.listeners;
    }
}

