/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.util;

import java.util.LinkedList;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.geotools.util.logging.LoggerAdapter;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;
import org.junit.Assume;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class LoggerRule
extends Handler
implements TestRule {
    private Logger log;
    private LinkedList<LogRecord> records = new LinkedList();
    private Level newLevel = null;
    private Level oldLevel = null;

    public LoggerRule(Logger log) {
        this.log = log;
    }

    public LoggerRule(Logger log, Level level) {
        this.log = log;
        super.setLevel(level);
        this.newLevel = level;
    }

    @Override
    public boolean isLoggable(LogRecord record) {
        return true;
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                LoggerRule.this.oldLevel = LoggerRule.this.log.getLevel();
                if (LoggerRule.this.newLevel != null) {
                    LoggerRule.this.log.setLevel(LoggerRule.this.newLevel);
                }
                LoggerRule.this.log.addHandler(LoggerRule.this);
                try {
                    base.evaluate();
                }
                finally {
                    LoggerRule.this.log.removeHandler(LoggerRule.this);
                    LoggerRule.this.log.setLevel(LoggerRule.this.oldLevel);
                    LoggerRule.this.oldLevel = null;
                }
            }
        };
    }

    @Override
    public void publish(LogRecord record) {
        this.records.add(record);
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
    }

    public void clear() {
        this.records.clear();
    }

    private void assumeCaptureWorks() {
        Assume.assumeFalse((String)"LoggerRule can't capture logs for LoggerAdapter", (boolean)(this.log instanceof LoggerAdapter));
    }

    public List<LogRecord> records() {
        this.assumeCaptureWorks();
        return this.records;
    }

    public void setTestLevel(Level testLevel) {
        this.log.setLevel(testLevel);
        this.newLevel = testLevel;
        super.setLevel(testLevel);
    }

    public void assertLogged(Matcher<? super LogRecord> matcher) {
        this.assertLogged("", matcher);
    }

    public void assertLogged(String reason, Matcher<? super LogRecord> matcher) {
        this.assumeCaptureWorks();
        for (LogRecord r : this.records) {
            if (!matcher.matches((Object)r)) continue;
            return;
        }
        StringDescription desc = new StringDescription();
        desc.appendText(reason);
        desc.appendText("\nExpected record: ");
        desc.appendDescriptionOf(matcher);
        desc.appendText("\n\tbut it was not logged");
        throw new AssertionError((Object)desc.toString());
    }
}

