/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.util;

import com.google.common.io.Files;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.zip.ZipOutputStream;
import org.geoserver.util.IOUtils;
import org.geoserver.util.ZipTestUtil;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class IOUtilsTest {
    @Rule
    public TemporaryFolder temp = new TemporaryFolder(new File("target"));

    @Test
    public void testZipUnzip() throws IOException {
        Path p1 = this.temp.newFolder("d1").toPath();
        p1.resolve("foo/bar").toFile().mkdirs();
        Files.touch((File)p1.resolve("foo/bar/bar.txt").toFile());
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ZipOutputStream zout = new ZipOutputStream(bout);
        IOUtils.zipDirectory((File)p1.toFile(), (ZipOutputStream)zout, null);
        Path p2 = this.temp.newFolder("d2").toPath();
        p2.toFile().mkdirs();
        ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
        IOUtils.decompress((InputStream)bin, (File)p2.toFile());
        Assert.assertTrue((boolean)p2.resolve("foo/bar/bar.txt").toFile().exists());
    }

    @Test
    public void testDecompressStreamBadEntryName() throws IOException {
        File destDir = this.temp.newFolder("d3").toPath().toFile();
        destDir.mkdirs();
        try (ByteArrayInputStream input = ZipTestUtil.getZipSlipInput();){
            IOUtils.decompress((InputStream)input, (File)destDir);
            Assert.fail((String)"Expected decompression to fail");
        }
        catch (IOException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.startsWith((String)"Entry is outside of the target directory"));
        }
    }

    @Test
    public void testDecompressFileBadEntryName() throws IOException {
        File destDir = this.temp.newFolder("d4").toPath().toFile();
        destDir.mkdirs();
        File input = ZipTestUtil.initZipSlipFile(this.temp.newFile("d4.zip"));
        try {
            IOUtils.decompress((File)input, (File)destDir);
            Assert.fail((String)"Expected decompression to fail");
        }
        catch (IOException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.startsWith((String)"Entry is outside of the target directory"));
        }
    }
}

