/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.platform;

import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import org.easymock.EasyMock;
import org.geoserver.platform.ClassExclusionFilter;
import org.geoserver.platform.ExtensionFilter;
import org.geoserver.platform.ExtensionProvider;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.NameExclusionFilter;
import org.geotools.util.logging.Logging;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.context.ApplicationContext;

public class GeoServerExtensionsTest {
    @Before
    public void setUp() throws Exception {
        System.setProperty("TEST_PROPERTY", "ABC");
    }

    @After
    public void tearDown() throws Exception {
        System.setProperty("TEST_PROPERTY", "");
        new GeoServerExtensions().setApplicationContext(null);
    }

    @Test
    public void testSetApplicationContext() {
        ApplicationContext appContext1 = (ApplicationContext)EasyMock.createMock(ApplicationContext.class);
        ApplicationContext appContext2 = (ApplicationContext)EasyMock.createMock(ApplicationContext.class);
        GeoServerExtensions gse = new GeoServerExtensions();
        gse.setApplicationContext(appContext1);
        GeoServerExtensions.extensionsCache.put(GeoServerExtensionsTest.class, (Object)new String[]{"fake"});
        Assert.assertSame((Object)appContext1, (Object)GeoServerExtensions.context);
        gse.setApplicationContext(appContext2);
        Assert.assertSame((Object)appContext2, (Object)GeoServerExtensions.context);
        Assert.assertEquals((long)0L, (long)GeoServerExtensions.extensionsCache.size());
    }

    @Test
    public void testExtensions() {
        ApplicationContext appContext = (ApplicationContext)EasyMock.createMock(ApplicationContext.class);
        GeoServerExtensions gse = new GeoServerExtensions();
        gse.setApplicationContext(appContext);
        Assert.assertEquals((long)0L, (long)GeoServerExtensions.extensionsCache.size());
        EasyMock.expect((Object)appContext.getBeanNamesForType(ExtensionFilter.class)).andReturn((Object)new String[0]);
        EasyMock.expect((Object)appContext.getBeanNamesForType(GeoServerExtensionsTest.class)).andReturn((Object)new String[]{"testKey", "fakeKey"});
        EasyMock.expect((Object)appContext.getBeanNamesForType(ExtensionProvider.class)).andReturn((Object)new String[0]);
        EasyMock.expect((Object)appContext.getBean("testKey")).andReturn((Object)this);
        EasyMock.expect((Object)appContext.isSingleton((String)EasyMock.anyObject())).andReturn((Object)true).anyTimes();
        EasyMock.expect((Object)appContext.getBean("fakeKey")).andReturn(null);
        EasyMock.replay((Object[])new Object[]{appContext});
        List extensions = GeoServerExtensions.extensions(GeoServerExtensionsTest.class);
        Assert.assertNotNull((Object)extensions);
        Assert.assertEquals((long)2L, (long)extensions.size());
        Assert.assertTrue((boolean)extensions.contains(this));
        Assert.assertTrue((boolean)extensions.contains(null));
        Assert.assertEquals((long)3L, (long)GeoServerExtensions.extensionsCache.size());
        Assert.assertTrue((boolean)GeoServerExtensions.extensionsCache.containsKey(GeoServerExtensionsTest.class));
        Assert.assertNotNull((Object)GeoServerExtensions.extensionsCache.get(GeoServerExtensionsTest.class));
        Assert.assertEquals((long)2L, (long)((String[])GeoServerExtensions.extensionsCache.get(GeoServerExtensionsTest.class)).length);
        EasyMock.verify((Object[])new Object[]{appContext});
    }

    @Test
    public void testExtensionsApplicationContext() {
        ApplicationContext appContext = (ApplicationContext)EasyMock.createMock(ApplicationContext.class);
        ApplicationContext customAppContext = (ApplicationContext)EasyMock.createMock(ApplicationContext.class);
        GeoServerExtensions gse = new GeoServerExtensions();
        gse.setApplicationContext(appContext);
        Assert.assertEquals((long)0L, (long)GeoServerExtensions.extensionsCache.size());
        EasyMock.expect((Object)customAppContext.getBeanNamesForType(ExtensionFilter.class)).andReturn((Object)new String[0]);
        EasyMock.expect((Object)customAppContext.getBeanNamesForType(GeoServerExtensionsTest.class)).andReturn((Object)new String[]{"itDoesntMatterForThePurpose"});
        EasyMock.expect((Object)customAppContext.getBeanNamesForType(ExtensionProvider.class)).andReturn((Object)new String[0]);
        EasyMock.expect((Object)customAppContext.getBeanNamesForType(ExtensionFilter.class)).andReturn((Object)new String[0]);
        EasyMock.expect((Object)customAppContext.getBean("itDoesntMatterForThePurpose")).andReturn((Object)this);
        EasyMock.expect((Object)appContext.isSingleton((String)EasyMock.anyObject())).andReturn((Object)true).anyTimes();
        EasyMock.expect((Object)customAppContext.isSingleton((String)EasyMock.anyObject())).andReturn((Object)true).anyTimes();
        EasyMock.replay((Object[])new Object[]{customAppContext});
        EasyMock.replay((Object[])new Object[]{appContext});
        List extensions = GeoServerExtensions.extensions(GeoServerExtensionsTest.class, (ApplicationContext)customAppContext);
        Assert.assertNotNull((Object)extensions);
        Assert.assertEquals((long)1L, (long)extensions.size());
        Assert.assertSame((Object)this, extensions.get(0));
        Assert.assertEquals((long)0L, (long)GeoServerExtensions.extensionsCache.size());
        EasyMock.verify((Object[])new Object[]{appContext});
        EasyMock.verify((Object[])new Object[]{customAppContext});
    }

    @Test
    public void testExtensionFilterByName() {
        ApplicationContext appContext = (ApplicationContext)EasyMock.createNiceMock(ApplicationContext.class);
        NameExclusionFilter filter = new NameExclusionFilter();
        filter.setBeanId("testId");
        EasyMock.expect((Object)appContext.getBeanNamesForType(ExtensionFilter.class)).andReturn((Object)new String[]{"filter"}).anyTimes();
        EasyMock.expect((Object)appContext.getBean("filter")).andReturn((Object)filter).anyTimes();
        EasyMock.expect((Object)appContext.getBeanNamesForType(GeoServerExtensionsTest.class)).andReturn((Object)new String[]{"testId"}).anyTimes();
        EasyMock.expect((Object)appContext.getBean("testId")).andReturn((Object)this).anyTimes();
        EasyMock.replay((Object[])new Object[]{appContext});
        GeoServerExtensions gse = new GeoServerExtensions();
        gse.setApplicationContext(appContext);
        List extensions = GeoServerExtensions.extensions(GeoServerExtensionsTest.class);
        Assert.assertEquals((long)0L, (long)extensions.size());
        filter.setBeanId("holabaloo");
        extensions = GeoServerExtensions.extensions(GeoServerExtensionsTest.class);
        Assert.assertEquals((long)1L, (long)extensions.size());
        Assert.assertSame((Object)this, extensions.get(0));
    }

    @Test
    public void testExtensionFilterByClass() {
        ApplicationContext appContext = (ApplicationContext)EasyMock.createNiceMock(ApplicationContext.class);
        ClassExclusionFilter filter = new ClassExclusionFilter();
        filter.setBeanClass(GeoServerExtensionsTest.class);
        EasyMock.expect((Object)appContext.getBeanNamesForType(ExtensionFilter.class)).andReturn((Object)new String[]{"filter"}).anyTimes();
        EasyMock.expect((Object)appContext.getBean("filter")).andReturn((Object)filter).anyTimes();
        EasyMock.expect((Object)appContext.getBeanNamesForType(GeoServerExtensionsTest.class)).andReturn((Object)new String[]{"testId"}).anyTimes();
        EasyMock.expect((Object)appContext.getBean("testId")).andReturn((Object)this).anyTimes();
        EasyMock.replay((Object[])new Object[]{appContext});
        GeoServerExtensions gse = new GeoServerExtensions();
        gse.setApplicationContext(appContext);
        List extensions = GeoServerExtensions.extensions(GeoServerExtensionsTest.class);
        Assert.assertEquals((long)0L, (long)extensions.size());
        filter.setBeanClass(Integer.class);
        extensions = GeoServerExtensions.extensions(GeoServerExtensionsTest.class);
        Assert.assertEquals((long)1L, (long)extensions.size());
        Assert.assertSame((Object)this, extensions.get(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBeanString() {
        ApplicationContext appContext = (ApplicationContext)EasyMock.createMock(ApplicationContext.class);
        GeoServerExtensions gse = new GeoServerExtensions();
        gse.setApplicationContext(null);
        Logger LOGGER = Logging.getLogger((String)"org.geoserver.platform");
        Level level = LOGGER.getLevel();
        try {
            LOGGER.setLevel(Level.SEVERE);
            Assert.assertNull((Object)GeoServerExtensions.bean((String)"beanName"));
        }
        finally {
            LOGGER.setLevel(level);
        }
        gse.setApplicationContext(appContext);
        EasyMock.expect((Object)appContext.isSingleton((String)EasyMock.anyObject())).andReturn((Object)true).anyTimes();
        EasyMock.expect((Object)appContext.getBean("beanName")).andReturn(null);
        EasyMock.expect((Object)appContext.getBean("beanName")).andReturn((Object)this);
        EasyMock.replay((Object[])new Object[]{appContext});
        Assert.assertNull((Object)GeoServerExtensions.bean((String)"beanName"));
        Assert.assertSame((Object)this, (Object)GeoServerExtensions.bean((String)"beanName"));
        EasyMock.verify((Object[])new Object[]{appContext});
    }

    @Test
    public void testExtensionProvider() {
        ApplicationContext appContext = (ApplicationContext)EasyMock.createMock(ApplicationContext.class);
        GeoServerExtensions gse = new GeoServerExtensions();
        gse.setApplicationContext(appContext);
        EasyMock.expect((Object)appContext.getBeanNamesForType(ExtensionFilter.class)).andReturn((Object)new String[0]);
        EasyMock.expect((Object)appContext.getBeanNamesForType(GeoServerExtensionsTest.class)).andReturn((Object)new String[0]);
        EasyMock.expect((Object)appContext.getBeanNamesForType(ExtensionProvider.class)).andReturn((Object)new String[]{"testKey2"});
        ExtensionProvider xp = (ExtensionProvider)EasyMock.createMock(ExtensionProvider.class);
        EasyMock.expect((Object)xp.getExtensionPoint()).andReturn(GeoServerExtensionsTest.class);
        EasyMock.expect((Object)xp.getExtensions(GeoServerExtensionsTest.class)).andReturn(Arrays.asList(this));
        EasyMock.expect((Object)appContext.getBean("testKey2")).andReturn((Object)xp);
        EasyMock.expect((Object)appContext.isSingleton((String)EasyMock.anyObject())).andReturn((Object)true).anyTimes();
        EasyMock.replay((Object[])new Object[]{xp});
        EasyMock.replay((Object[])new Object[]{appContext});
        Assert.assertEquals((long)1L, (long)GeoServerExtensions.extensions(GeoServerExtensionsTest.class).size());
        EasyMock.verify((Object[])new Object[]{xp});
        EasyMock.verify((Object[])new Object[]{appContext});
    }

    @Test
    public void testSystemProperty() {
        Assert.assertEquals((Object)"ABC", (Object)GeoServerExtensions.getProperty((String)"TEST_PROPERTY", (ApplicationContext)null));
        Assert.assertEquals((Object)"ABC", (Object)GeoServerExtensions.getProperty((String)"TEST_PROPERTY", (ServletContext)null));
    }

    @Test
    public void testWebProperty() {
        ServletContext servletContext = (ServletContext)EasyMock.createMock(ServletContext.class);
        EasyMock.expect((Object)servletContext.getInitParameter("TEST_PROPERTY")).andReturn((Object)"DEF").anyTimes();
        EasyMock.expect((Object)servletContext.getInitParameter("WEB_PROPERTY")).andReturn((Object)"WWW").anyTimes();
        EasyMock.replay((Object[])new Object[]{servletContext});
        Assert.assertEquals((Object)"ABC", (Object)GeoServerExtensions.getProperty((String)"TEST_PROPERTY", (ServletContext)servletContext));
        Assert.assertEquals((Object)"WWW", (Object)GeoServerExtensions.getProperty((String)"WEB_PROPERTY", (ServletContext)servletContext));
    }
}

