/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows;

import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.geoserver.ows.Request;
import org.geoserver.platform.Service;
import org.geoserver.platform.ServiceException;
import org.geotools.util.logging.Logging;

public abstract class ServiceExceptionHandler {
    protected static final String DEFAULT_XML_MIME_TYPE = "application/xml";
    protected static Logger LOGGER = Logging.getLogger((String)"org.geoserver.ows");
    List<Service> services;

    public ServiceExceptionHandler(List<Service> services) {
        this.services = services;
    }

    public ServiceExceptionHandler(Service service) {
        this.services = Collections.singletonList(service);
    }

    public List<Service> getServices() {
        return this.services;
    }

    public abstract void handleServiceException(ServiceException var1, Request var2);

    public boolean canHandle(Service service, Request request) {
        return service != null && this.getServices().contains(service);
    }
}

