/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Set;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;

public abstract class Response {
    public static final String DISPOSITION_INLINE = "inline";
    public static final String DISPOSITION_ATTACH = "attachment";
    final Class<?> binding;
    final Set<String> outputFormats;

    public Response(Class<?> binding) {
        this(binding, (Set<String>)null);
    }

    public Response(Class<?> binding, String outputFormat) {
        this(binding, outputFormat == null ? null : Collections.singleton(outputFormat));
    }

    public Response(Class<?> binding, Set<String> outputFormats) {
        if (binding == null) {
            throw new NullPointerException("binding may not be null");
        }
        if (outputFormats == null) {
            outputFormats = Collections.emptySet();
        }
        this.binding = binding;
        this.outputFormats = outputFormats;
    }

    public final Class<?> getBinding() {
        return this.binding;
    }

    public final Set<String> getOutputFormats() {
        return this.outputFormats;
    }

    public boolean canHandle(Operation operation) {
        return true;
    }

    public abstract String getMimeType(Object var1, Operation var2) throws ServiceException;

    public String[][] getHeaders(Object value, Operation operation) throws ServiceException {
        return null;
    }

    public abstract void write(Object var1, OutputStream var2, Operation var3) throws IOException, ServiceException;

    public String getPreferredDisposition(Object value, Operation operation) {
        return DISPOSITION_INLINE;
    }

    public String getAttachmentFileName(Object value, Operation operation) {
        String mimeType = this.getMimeType(value, operation);
        String opName = operation.getId();
        Object name = null;
        if (mimeType != null) {
            name = "geoserver";
            if (opName != null) {
                name = (String)name + "-" + opName;
            }
            String[] typeParts = mimeType.split(";");
            name = (String)name + "." + typeParts[0].split("/")[0];
        }
        return name;
    }

    public String getCharset(Operation operation) {
        return null;
    }
}

