/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import javax.servlet.http.HttpServletResponse;
import net.opengis.ows11.ExceptionReportType;
import org.eclipse.xsd.XSDSchema;
import org.geoserver.ows.Ows11Util;
import org.geoserver.ows.Request;
import org.geoserver.ows.ServiceExceptionHandler;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.Service;
import org.geoserver.platform.ServiceException;
import org.geotools.ows.v1_1.OWS;
import org.geotools.ows.v1_1.OWSConfiguration;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.Encoder;

public class OWS11ServiceExceptionHandler
extends ServiceExceptionHandler {
    static String CONTENT_TYPE = System.getProperty("ows11.exception.xml.responsetype", "application/xml");
    protected boolean verboseExceptions = false;
    protected boolean useServiceVersion = false;

    public OWS11ServiceExceptionHandler() {
        super(Collections.emptyList());
    }

    public OWS11ServiceExceptionHandler(List<Service> services) {
        super(services);
    }

    public OWS11ServiceExceptionHandler(Service service) {
        super(Arrays.asList(service));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleServiceException(ServiceException exception, Request request) {
        XSDSchema result;
        String version = null;
        if (this.useServiceVersion && request.getServiceDescriptor() != null) {
            version = request.getServiceDescriptor().getVersion().toString();
        }
        ExceptionReportType report = Ows11Util.exceptionReport(exception, this.verboseExceptions, version);
        HttpServletResponse response = request.getHttpResponse();
        if (!request.isSOAP()) {
            response.setContentType(CONTENT_TYPE);
        }
        OWSConfiguration configuration = new OWSConfiguration();
        try {
            result = configuration.getXSD().getSchema();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Encoder encoder = new Encoder((Configuration)configuration, result);
        encoder.setIndenting(true);
        encoder.setIndentSize(2);
        encoder.setLineWidth(60);
        encoder.setOmitXMLDeclaration(request.isSOAP());
        String schemaLocation = ResponseUtils.buildSchemaURL(ResponseUtils.baseURL(request.getHttpRequest()), "ows/1.1.0/owsAll.xsd");
        encoder.setSchemaLocation("http://www.opengis.net/ows/1.1", schemaLocation);
        try {
            encoder.encode((Object)report, OWS.ExceptionReport, (OutputStream)response.getOutputStream());
        }
        catch (Exception ex) {
            LOGGER.log(Level.INFO, "Problem writing exception information back to calling client:", ex);
        }
        finally {
            try {
                response.getOutputStream().flush();
            }
            catch (IOException iOException) {}
        }
    }

    public void setUseServiceVersion(boolean useServiceVersion) {
        this.useServiceVersion = useServiceVersion;
    }
}

