/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows.util;

import javax.servlet.http.HttpServletRequest;
import org.geoserver.ows.util.RequestUtils;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;

public class RequestUtilsTest {
    @Test
    public void testGetRemoteAddrNotForwarded() {
        HttpServletRequest req = RequestUtilsTest.request("192.168.1.1", null);
        Assert.assertEquals((Object)"192.168.1.1", (Object)RequestUtils.getRemoteAddr((HttpServletRequest)req));
    }

    @Test
    public void testGetRemoteAddrSingleForwardedIP() {
        HttpServletRequest req = RequestUtilsTest.request("192.168.1.2", "192.168.1.1");
        Assert.assertEquals((Object)"192.168.1.1", (Object)RequestUtils.getRemoteAddr((HttpServletRequest)req));
    }

    @Test
    public void testGetRemoteAddrMultipleForwardedIP() {
        HttpServletRequest req = RequestUtilsTest.request("192.168.1.4", "192.168.1.1, 192.168.1.2, 192.168.1.3");
        Assert.assertEquals((Object)"192.168.1.1", (Object)RequestUtils.getRemoteAddr((HttpServletRequest)req));
    }

    private static HttpServletRequest request(String remoteAddr, String forwardedFor) {
        MockHttpServletRequest req = new MockHttpServletRequest();
        req.setRemoteAddr(remoteAddr);
        if (forwardedFor != null) {
            req.addHeader("X-Forwarded-For", (Object)forwardedFor);
        }
        return req;
    }
}

