/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows.kvp;

import java.util.Map;
import org.geoserver.ows.kvp.FormatOptionsKvpParser;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FormatOptionsKvpParserTest {
    private FormatOptionsKvpParser parser;

    @Before
    public void setUp() throws Exception {
        this.parser = new FormatOptionsKvpParser();
    }

    @Test
    public void testPairs() throws Exception {
        Map expected = Map.ofEntries(Map.entry("key1", "value1"), Map.entry("key2", "value2"), Map.entry("key3", "true"), Map.entry("key4", "value4"));
        Map actual = (Map)this.parser.parse("key1:value1;key2:value2;key3;key4:value4");
        Assert.assertEquals(expected, (Object)actual);
    }

    @Test
    public void testEscapedSeparators() throws Exception {
        Map expected = Map.ofEntries(Map.entry("key1", "value:1"), Map.entry("key2", "value:2"), Map.entry("key3", "value:3;ZZZ"));
        Map actual = (Map)this.parser.parse("key1:value\\:1;key2:value\\:2;key3:value\\:3\\;ZZZ");
        Assert.assertEquals(expected, (Object)actual);
    }

    @Test
    public void testEmbeddedSeparators() throws Exception {
        Map expected = Map.ofEntries(Map.entry("key1", "value:1"), Map.entry("key2", "value:2"), Map.entry("key3", "value:3:ZZ;XX"));
        Map actual = (Map)this.parser.parse("key1:value:1;key2:value:2;key3:value:3\\:ZZ\\;XX");
        Assert.assertEquals(expected, (Object)actual);
    }

    @Test
    public void testErrors() throws Exception {
        Map expected = Map.ofEntries(Map.entry("key1", "value:1"), Map.entry("key2", "value:2"), Map.entry("key3", "value:3"));
        Map actual = (Map)this.parser.parse("key1:value:1;key2:value:2;key3:value:3");
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        Assert.assertEquals(expected, (Object)actual);
    }
}

