/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows;

import java.io.BufferedReader;
import java.io.Reader;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.fileupload.FileItem;
import org.geoserver.ows.AbstractDispatcherCallback;
import org.geoserver.ows.Request;
import org.geotools.util.logging.Logging;

public class FileItemCleanupCallback
extends AbstractDispatcherCallback {
    private static final Logger LOGGER = Logging.getLogger(FileItemCleanupCallback.class);
    private static final ThreadLocal<List<FileItem>> FILE_ITEMS = ThreadLocal.withInitial(Collections::emptyList);

    public static void setFileItems(List<FileItem> fileItems) {
        FILE_ITEMS.set(fileItems);
    }

    @Override
    public void finished(Request request) {
        List<FileItem> items = FILE_ITEMS.get();
        FILE_ITEMS.remove();
        if (!items.isEmpty()) {
            try {
                BufferedReader ignored = request.getInput();
                if (ignored != null) {
                    ((Reader)ignored).close();
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.FINEST, "Unable to close request input", e);
            }
            items.forEach(FileItem::delete);
        }
    }
}

