/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.geoserver.ows.util.EncodingInfo;
import org.geoserver.ows.util.RewindableInputStream;
import org.geoserver.ows.util.UCSReader;
import org.geotools.util.logging.Logging;

public class XmlCharsetDetector {
    protected static Logger LOGGER = Logging.getLogger((String)"org.vfny.geoserver.requests");
    private static final char RIGHT_ANGLE_BRACKET = '>';
    private static final Pattern ENCODING_PATTERN = Pattern.compile("encoding\\s*\\=\\s*\"([^\"]+)\"");
    private static final int MAX_XMLDECL_SIZE = 100;

    public static Reader getCharsetAwareReader(InputStream istream, EncodingInfo encInfo) throws IOException, UnsupportedCharsetException {
        int b;
        int count;
        RewindableInputStream stream = new RewindableInputStream(istream, false);
        byte[] b4 = new byte[4];
        for (count = 0; count < 4 && -1 != (b = stream.read()); ++count) {
            b4[count] = (byte)b;
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("First 4 bytes of XML doc are : " + Integer.toHexString(b4[0] & 0xFF).toUpperCase() + " ('" + (char)b4[0] + "') " + Integer.toHexString(b4[1] & 0xFF).toUpperCase() + " ('" + (char)b4[1] + "') " + Integer.toHexString(b4[2] & 0xFF).toUpperCase() + " ('" + (char)b4[2] + "') " + Integer.toHexString(b4[3] & 0xFF).toUpperCase() + " ('" + (char)b4[3] + "')");
        }
        encInfo.copyFrom(XmlCharsetDetector.getEncodingName(b4, count));
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Charset detection phase 1. Inferred encoding: " + encInfo);
        }
        stream.reset();
        String ENCODING = encInfo.getEncoding().toUpperCase(Locale.ENGLISH);
        Boolean isBigEndian = encInfo.isBigEndian();
        boolean hasBOM = encInfo.hasBOM();
        if (hasBOM && ENCODING.equals("UTF-8") && stream.skip(3L) < 3L) {
            return null;
        }
        if (count > 1 && (ENCODING.equals("UTF-16LE") || ENCODING.equals("UTF-16BE"))) {
            int b0 = b4[0] & 0xFF;
            int b1 = b4[1] & 0xFF;
            if ((b0 == 255 && b1 == 254 || b0 == 254 && b1 == 255) && stream.skip(2L) < 2L) {
                return null;
            }
        }
        Reader reader = null;
        if ("ISO-10646-UCS-4".equals(ENCODING)) {
            if (null != isBigEndian) {
                boolean isBE = isBigEndian;
                reader = isBE ? new UCSReader(stream, 8) : new UCSReader(stream, 4);
            } else {
                String s = "Unsupported byte order for ISO-10646-UCS-4 encoding.";
                throw new UnsupportedCharsetException(s);
            }
        }
        if (null == reader) {
            reader = new InputStreamReader((InputStream)stream, ENCODING);
        }
        String declEncoding = XmlCharsetDetector.getXmlEncoding(reader);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Charset detection phase 2. Charset in XML declaration is `" + declEncoding + "`.");
        }
        stream.reset();
        stream.setChunkedMode(true);
        if (null != declEncoding && !declEncoding.equals(ENCODING) && !declEncoding.equals("ISO-10646-UCS-2")) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Declared charset differs from inferred one. Trying to construct InputStreamReader for `" + declEncoding + "`.");
            }
            reader = new InputStreamReader((InputStream)stream, declEncoding);
            encInfo.setEncoding(declEncoding);
        }
        return reader;
    }

    public static Reader getCharsetAwareReader(InputStream istream) throws IOException, UnsupportedCharsetException {
        return XmlCharsetDetector.getCharsetAwareReader(istream, new EncodingInfo());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static Reader createReader(InputStream istream, EncodingInfo encInfo) throws IllegalArgumentException, UnsupportedEncodingException {
        void var4_13;
        String charset = encInfo.getEncoding();
        Boolean isBigEndian = encInfo.isBigEndian();
        if (null == charset) {
            String string = "Name of the charset must not be NULL!";
            throw new IllegalArgumentException(string);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Trying to create reader basing on existing charset information: `" + encInfo + "`.");
        }
        Object var4_5 = null;
        if ("ISO-10646-UCS-4".equals(charset)) {
            if (null == isBigEndian) {
                String s = "Unsupported byte order for ISO-10646-UCS-4 encoding.";
                throw new UnsupportedEncodingException(s);
            }
            boolean isBE = isBigEndian;
            if (isBE) {
                UCSReader uCSReader = new UCSReader(istream, 8);
                return var4_13;
            }
            UCSReader uCSReader = new UCSReader(istream, 4);
            return var4_13;
        }
        if (!"ISO-10646-UCS-2".equals(charset)) {
            InputStreamReader inputStreamReader = new InputStreamReader(istream, charset);
            return var4_13;
        }
        if (null == isBigEndian) {
            String s = "Byte order must be specified for ISO-10646-UCS-2.";
            throw new UnsupportedEncodingException(s);
        }
        boolean isBE = isBigEndian;
        if (isBE) {
            UCSReader uCSReader = new UCSReader(istream, 8);
            return var4_13;
        }
        UCSReader uCSReader = new UCSReader(istream, 4);
        return var4_13;
    }

    public static EncodingInfo getEncodingName(byte[] b4, int count) {
        if (count < 2) {
            return new EncodingInfo("UTF-8", null);
        }
        int b0 = b4[0] & 0xFF;
        int b1 = b4[1] & 0xFF;
        if (b0 == 254 && b1 == 255) {
            return new EncodingInfo("UTF-16BE", Boolean.TRUE, true);
        }
        if (b0 == 255 && b1 == 254) {
            return new EncodingInfo("UTF-16LE", Boolean.FALSE, true);
        }
        if (count < 3) {
            return new EncodingInfo("UTF-8", null);
        }
        int b2 = b4[2] & 0xFF;
        if (b0 == 239 && b1 == 187 && b2 == 191) {
            return new EncodingInfo("UTF-8", null, true);
        }
        if (count < 4) {
            return new EncodingInfo("UTF-8", null);
        }
        int b3 = b4[3] & 0xFF;
        if (b0 == 0 && b1 == 0 && b2 == 0 && b3 == 60) {
            return new EncodingInfo("ISO-10646-UCS-4", Boolean.TRUE);
        }
        if (b0 == 60 && b1 == 0 && b2 == 0 && b3 == 0) {
            return new EncodingInfo("ISO-10646-UCS-4", Boolean.FALSE);
        }
        if (b0 == 0 && b1 == 0 && b2 == 60 && b3 == 0) {
            return new EncodingInfo("ISO-10646-UCS-4", null);
        }
        if (b0 == 0 && b1 == 60 && b2 == 0 && b3 == 0) {
            return new EncodingInfo("ISO-10646-UCS-4", null);
        }
        if (b0 == 0 && b1 == 60 && b2 == 0 && b3 == 63) {
            return new EncodingInfo("UTF-16BE", Boolean.TRUE);
        }
        if (b0 == 60 && b1 == 0 && b2 == 63 && b3 == 0) {
            return new EncodingInfo("UTF-16LE", Boolean.FALSE);
        }
        if (b0 == 76 && b1 == 111 && b2 == 167 && b3 == 148) {
            return new EncodingInfo("CP037", null);
        }
        return new EncodingInfo("UTF-8", null);
    }

    protected static String getXmlEncoding(Reader reader) {
        try {
            int c;
            int count;
            StringWriter sw = new StringWriter(100);
            for (count = 0; 6 > count && -1 != (c = reader.read()); ++count) {
                sw.write(c);
            }
            if (6 > count || !"<?xml ".equals(sw.toString())) {
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("Invalid(?) XML declaration: " + sw + ".");
                }
                return null;
            }
            while (100 > count && -1 != (c = reader.read()) && '>' != (char)c) {
                sw.write(c);
                ++count;
            }
            Matcher m = ENCODING_PATTERN.matcher(sw.toString());
            if (m.find()) {
                String result = m.group(1);
                return result;
            }
            return null;
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning("Failed to extract charset info from XML declaration due to IOException: " + e.getMessage());
            }
            return null;
        }
    }
}

