/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.ows.AbstractURLPublisher;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geotools.util.URLs;
import org.springframework.web.context.support.ServletContextResource;
import org.springframework.web.context.support.ServletContextResourceLoader;

public class FilePublisher
extends AbstractURLPublisher {
    public static final String DISABLE_STATIC_WEB_FILES = "GEOSERVER_DISABLE_STATIC_WEB_FILES";
    protected GeoServerResourceLoader loader;
    protected ServletContextResourceLoader scloader;

    public FilePublisher(GeoServerResourceLoader loader) {
        this.loader = loader;
    }

    protected void initServletContext(ServletContext servletContext) {
        this.scloader = new ServletContextResourceLoader(servletContext);
    }

    @Override
    protected String getMimeType(String reqPath, String filename) {
        String prop;
        String lowerCaseMime;
        String mimeType = super.getMimeType(reqPath, filename);
        if (!("/index.html".equals(reqPath) || "/accessDenied.html".equals(reqPath) || !(lowerCaseMime = mimeType.toLowerCase()).contains("html") && !lowerCaseMime.contains("javascript") || !Boolean.parseBoolean(prop = GeoServerExtensions.getProperty((String)DISABLE_STATIC_WEB_FILES)) && reqPath.startsWith("/www/"))) {
            return "text/plain";
        }
        return mimeType;
    }

    @Override
    protected boolean isAttachment(String reqPath, String filename, String mime) {
        return mime.toLowerCase().contains("xml") || super.isAttachment(reqPath, filename, mime);
    }

    @Override
    protected URL getUrl(HttpServletRequest request, String reqPath) throws IOException {
        ServletContextResource resource;
        File file;
        if (reqPath.length() > 1 && reqPath.startsWith("/")) {
            reqPath = reqPath.substring(1);
        }
        File file2 = file = "index.html".equals(reqPath) ? null : this.loader.find(reqPath);
        if (file == null && this.scloader != null && (resource = (ServletContextResource)this.scloader.getResource(reqPath)) != null && resource.exists()) {
            file = resource.getFile();
        }
        if (file != null) {
            return URLs.fileToUrl((File)file);
        }
        return null;
    }
}

