/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows.util;

import java.util.HashMap;
import java.util.Map;
import org.geoserver.ows.util.OwsUtils;
import org.junit.Assert;
import org.junit.Test;

public class OwsUtilsTest {
    @Test
    public void testSimple() throws Exception {
        Foo foo = new Foo();
        foo.setA("a");
        Assert.assertEquals((Object)"a", (Object)OwsUtils.get((Object)foo, (String)"a"));
        Assert.assertNull((Object)OwsUtils.get((Object)foo, (String)"b"));
        OwsUtils.set((Object)foo, (String)"b", (Object)5);
        Assert.assertEquals((Object)5, (Object)OwsUtils.get((Object)foo, (String)"b"));
        Assert.assertEquals((Object)Float.valueOf(0.0f), (Object)OwsUtils.get((Object)foo, (String)"c"));
        OwsUtils.set((Object)foo, (String)"c", (Object)Float.valueOf(5.0f));
        Assert.assertEquals((Object)Float.valueOf(5.0f), (Object)OwsUtils.get((Object)foo, (String)"c"));
    }

    @Test
    public void testExtended() throws Exception {
        Bar bar = new Bar();
        Assert.assertNull((Object)OwsUtils.get((Object)bar, (String)"foo"));
        Assert.assertNull((Object)OwsUtils.get((Object)bar, (String)"foo.a"));
        Foo foo = new Foo();
        bar.setFoo(foo);
        Assert.assertEquals((Object)foo, (Object)OwsUtils.get((Object)bar, (String)"foo"));
        Assert.assertNull((Object)OwsUtils.get((Object)bar, (String)"foo.a"));
        foo.setA("abc");
        Assert.assertEquals((Object)"abc", (Object)OwsUtils.get((Object)bar, (String)"foo.a"));
        OwsUtils.set((Object)bar, (String)"foo.b", (Object)123);
        Assert.assertEquals((Object)123, (Object)OwsUtils.get((Object)bar, (String)"foo.b"));
    }

    @Test
    public void testPut() throws Exception {
        Baz baz = new Baz();
        try {
            OwsUtils.put((Object)baz, (String)"map", (Object)"k", (Object)"v");
            Assert.fail((String)"null map should cause exception");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        baz.map = new HashMap();
        try {
            OwsUtils.put((Object)baz, (String)"xyz", (Object)"k", (Object)"v");
            Assert.fail((String)"bad property should cause exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)baz.map.isEmpty());
        OwsUtils.put((Object)baz, (String)"map", (Object)"k", (Object)"v");
        Assert.assertEquals((Object)"v", baz.map.get("k"));
    }

    class Baz {
        Map map;

        Baz() {
        }

        public Map getMap() {
            return this.map;
        }
    }

    class Bar {
        Foo foo;
        Double d;

        Bar() {
        }

        public Foo getFoo() {
            return this.foo;
        }

        public void setFoo(Foo foo) {
            this.foo = foo;
        }

        public Double getD() {
            return this.d;
        }

        public void setD(Double d) {
            this.d = d;
        }
    }

    class Foo {
        String a;
        Integer b;
        float c;

        Foo() {
        }

        public String getA() {
            return this.a;
        }

        public void setA(String a) {
            this.a = a;
        }

        public Integer getB() {
            return this.b;
        }

        public void setB(Integer b) {
            this.b = b;
        }

        public float getC() {
            return this.c;
        }

        public void setC(float c) {
            this.c = c;
        }
    }
}

