/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows.kvp;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.geoserver.ows.util.KvpMap;
import org.geoserver.ows.util.KvpUtils;
import org.junit.Assert;
import org.junit.Test;

public class KvpUtilsTest {
    @Test
    public void testEmptyString() {
        Assert.assertEquals((long)0L, (long)KvpUtils.readFlat((String)"").size());
    }

    @Test
    public void testTrailingEmtpyStrings() {
        Assert.assertEquals(Arrays.asList("x", "", "x", "", ""), (Object)KvpUtils.readFlat((String)"x,,x,,"));
    }

    @Test
    public void testEmtpyNestedString() {
        List result = KvpUtils.readNested((String)"");
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((long)0L, (long)((List)result.get(0)).size());
    }

    @Test
    public void testNullKvp() {
        KvpMap result = KvpUtils.toStringKVP(null);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testStarNestedString() {
        List result = KvpUtils.readNested((String)"*");
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((long)0L, (long)((List)result.get(0)).size());
    }

    @Test
    public void testWellKnownTokenizers() {
        String[] expected = new String[]{"1", "2", "3", ""};
        List actual = KvpUtils.readFlat((String)"1,2,3,", (KvpUtils.Tokenizer)KvpUtils.INNER_DELIMETER);
        this.assertKvp(expected, actual);
        expected = new String[]{"abc", "def", ""};
        actual = KvpUtils.readFlat((String)"(abc)(def)()", (KvpUtils.Tokenizer)KvpUtils.OUTER_DELIMETER);
        this.assertKvp(expected, actual);
        expected = new String[]{"abc"};
        actual = KvpUtils.readFlat((String)"(abc)", (KvpUtils.Tokenizer)KvpUtils.OUTER_DELIMETER);
        this.assertKvp(expected, actual);
        expected = new String[]{""};
        actual = KvpUtils.readFlat((String)"()", (KvpUtils.Tokenizer)KvpUtils.OUTER_DELIMETER);
        this.assertKvp(expected, actual);
        expected = new String[]{"", "A=1", "B=2", ""};
        actual = KvpUtils.readFlat((String)";A=1;B=2;", (KvpUtils.Tokenizer)KvpUtils.CQL_DELIMITER);
        this.assertKvp(expected, actual);
        expected = new String[]{"ab", "cd", "ef", ""};
        actual = KvpUtils.readFlat((String)"ab&cd&ef&", (KvpUtils.Tokenizer)KvpUtils.KEYWORD_DELIMITER);
        this.assertKvp(expected, actual);
        expected = new String[]{"A", "1 "};
        actual = KvpUtils.readFlat((String)"A=1 ", (KvpUtils.Tokenizer)KvpUtils.VALUE_DELIMITER);
        this.assertKvp(expected, actual);
    }

    @Test
    public void testRadFlatUnkownDelimiter() {
        String[] expected = new String[]{"1", "2", "3", ""};
        List actual = KvpUtils.readFlat((String)"1^2^3^", (String)"\\^");
        this.assertKvp(expected, actual);
        actual = KvpUtils.readFlat((String)"1-2-3-", (String)"-");
        this.assertKvp(expected, actual);
    }

    private void assertKvp(String[] expected, List actual) {
        List<String> expectedList = Arrays.asList(expected);
        Assert.assertEquals((long)expectedList.size(), (long)actual.size());
        Assert.assertEquals(expectedList, (Object)actual);
    }

    @Test
    public void testEscapedTokens() {
        List actual = KvpUtils.escapedTokens((String)"", (char)',');
        Assert.assertEquals(Arrays.asList(""), (Object)actual);
        actual = KvpUtils.escapedTokens((String)",", (char)',');
        Assert.assertEquals(Arrays.asList("", ""), (Object)actual);
        actual = KvpUtils.escapedTokens((String)"a,b", (char)',');
        Assert.assertEquals(Arrays.asList("a", "b"), (Object)actual);
        actual = KvpUtils.escapedTokens((String)"a,b,c", (char)',');
        Assert.assertEquals(Arrays.asList("a", "b", "c"), (Object)actual);
        actual = KvpUtils.escapedTokens((String)"a,b,c", (char)',', (int)2);
        Assert.assertEquals(Arrays.asList("a", "b,c"), (Object)actual);
        actual = KvpUtils.escapedTokens((String)"a,b,c", (char)',', (int)1);
        Assert.assertEquals(Arrays.asList("a,b,c"), (Object)actual);
        actual = KvpUtils.escapedTokens((String)"a,b,c", (char)',', (int)0);
        Assert.assertEquals(Arrays.asList("a", "b", "c"), (Object)actual);
        actual = KvpUtils.escapedTokens((String)"a,b,c", (char)',', (int)1000);
        Assert.assertEquals(Arrays.asList("a", "b", "c"), (Object)actual);
        actual = KvpUtils.escapedTokens((String)"\\\\,\\\\", (char)',');
        Assert.assertEquals(Arrays.asList("\\\\", "\\\\"), (Object)actual);
        actual = KvpUtils.escapedTokens((String)"a\\,b,c", (char)',');
        Assert.assertEquals(Arrays.asList("a\\,b", "c"), (Object)actual);
        actual = KvpUtils.escapedTokens((String)"a\\,b,c,d", (char)',', (int)2);
        Assert.assertEquals(Arrays.asList("a\\,b", "c,d"), (Object)actual);
        try {
            KvpUtils.escapedTokens(null, (char)',');
            Assert.fail((String)"Expected IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            KvpUtils.escapedTokens((String)"", (char)'\\');
            Assert.fail((String)"Expected IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            KvpUtils.escapedTokens((String)"\\", (char)'\\');
            Assert.fail((String)"Expected IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testUnescape() {
        String actual = KvpUtils.unescape((String)"abc");
        Assert.assertEquals((Object)"abc", (Object)actual);
        actual = KvpUtils.unescape((String)"abc\\\\");
        Assert.assertEquals((Object)"abc\\", (Object)actual);
        actual = KvpUtils.unescape((String)"abc\\d");
        Assert.assertEquals((Object)"abcd", (Object)actual);
        try {
            KvpUtils.unescape(null);
            Assert.fail((String)"Expected IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            KvpUtils.unescape((String)"\\");
            Assert.fail((String)"Expected IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testParseQueryString() {
        Map kvp = KvpUtils.parseQueryString((String)"geoserver?request=WMS&version=1.0.0&CQL_FILTER=NAME='geoserver'");
        Assert.assertEquals((long)3L, (long)kvp.size());
        Assert.assertEquals((Object)"WMS", kvp.get("request"));
        Assert.assertEquals((Object)"1.0.0", kvp.get("version"));
        Assert.assertEquals((Object)"NAME='geoserver'", kvp.get("CQL_FILTER"));
    }

    @Test
    public void testParseQueryStringRepeated() {
        Map kvp = KvpUtils.parseQueryString((String)"geoserver?request=WMS&version=1.0.0&version=2.0.0&CQL_FILTER=NAME='geoserver'");
        Assert.assertEquals((long)3L, (long)kvp.size());
        Assert.assertEquals((Object)"WMS", kvp.get("request"));
        Assert.assertArrayEquals((Object[])new String[]{"1.0.0", "2.0.0"}, (Object[])((String[])kvp.get("version")));
        Assert.assertEquals((Object)"NAME='geoserver'", kvp.get("CQL_FILTER"));
    }
}

