/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows.kvp;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import org.geoserver.ows.kvp.ElevationKvpParser;
import org.geoserver.platform.ServiceException;
import org.geotools.util.NumberRange;
import org.junit.Assert;
import org.junit.Test;

public class ElevationKvpParserTest {
    @Test
    public void testPeriod() throws ParseException {
        ElevationKvpParser parser = new ElevationKvpParser("ELEVATION");
        ArrayList elements = new ArrayList((Collection)parser.parse("1/100/1"));
        Assert.assertTrue((boolean)(elements.get(0) instanceof Double));
        Assert.assertEquals((long)100L, (long)elements.size());
        Assert.assertEquals((double)1.0, (double)((Double)elements.get(0)), (double)0.0);
    }

    @Test
    public void testMixed() throws ParseException {
        ElevationKvpParser parser = new ElevationKvpParser("ELEVATION");
        ArrayList elements = new ArrayList((Collection)parser.parse("5,3,4,1,2,8.9,1/9"));
        Assert.assertTrue((boolean)(elements.get(0) instanceof NumberRange));
        Assert.assertEquals((double)1.0, (double)((NumberRange)elements.get(0)).getMinimum(), (double)0.0);
        Assert.assertEquals((double)9.0, (double)((NumberRange)elements.get(0)).getMaximum(), (double)0.0);
    }

    @Test
    public void testOutOfOrderSequence() throws ParseException {
        ElevationKvpParser parser = new ElevationKvpParser("ELEVATION");
        ArrayList elements = new ArrayList((Collection)parser.parse("5,3,4,1,2,8.9"));
        Assert.assertEquals((Object)1.0, elements.get(0));
        Assert.assertEquals((Object)2.0, elements.get(1));
        Assert.assertEquals((Object)3.0, elements.get(2));
        Assert.assertEquals((Object)4.0, elements.get(3));
        Assert.assertEquals((Object)5.0, elements.get(4));
        Assert.assertEquals((Object)8.9, elements.get(5));
    }

    @Test
    public void testOrderedSequence() throws ParseException {
        ElevationKvpParser parser = new ElevationKvpParser("ELEVATION");
        ArrayList elements = new ArrayList((Collection)parser.parse("1,2,3,4,5,8.9"));
        Assert.assertEquals((Object)1.0, elements.get(0));
        Assert.assertEquals((Object)2.0, elements.get(1));
        Assert.assertEquals((Object)3.0, elements.get(2));
        Assert.assertEquals((Object)4.0, elements.get(3));
        Assert.assertEquals((Object)5.0, elements.get(4));
        Assert.assertEquals((Object)8.9, elements.get(5));
    }

    @Test
    public void testInfiniteLoopZeroInterval() {
        String value = "0/0/0";
        ServiceException e = (ServiceException)Assert.assertThrows(ServiceException.class, () -> new ElevationKvpParser("ELEVATION").parse(value));
        Assert.assertEquals((Object)"Exceeded 100 iterations parsing elevations, bailing out.", (Object)e.getMessage());
        Assert.assertEquals((Object)"InvalidParameterValue", (Object)e.getCode());
        Assert.assertEquals((Object)"elevation", (Object)e.getLocator());
    }

    @Test
    public void testInfiniteLoopPositiveInfinity() {
        String value = "Infinity/Infinity/1";
        ServiceException e = (ServiceException)Assert.assertThrows(ServiceException.class, () -> new ElevationKvpParser("ELEVATION").parse(value));
        Assert.assertEquals((Object)"Exceeded 100 iterations parsing elevations, bailing out.", (Object)e.getMessage());
        Assert.assertEquals((Object)"InvalidParameterValue", (Object)e.getCode());
        Assert.assertEquals((Object)"elevation", (Object)e.getLocator());
    }

    @Test
    public void testInfiniteLoopNegativeInfinity() {
        String value = "-Infinity/-Infinity/1";
        ServiceException e = (ServiceException)Assert.assertThrows(ServiceException.class, () -> new ElevationKvpParser("ELEVATION").parse(value));
        Assert.assertEquals((Object)"Exceeded 100 iterations parsing elevations, bailing out.", (Object)e.getMessage());
        Assert.assertEquals((Object)"InvalidParameterValue", (Object)e.getCode());
        Assert.assertEquals((Object)"elevation", (Object)e.getLocator());
    }
}

