/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows;

import com.google.common.base.Strings;
import java.io.File;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.ows.Dispatcher;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

public class FileItemCleanupCallbackTest {
    private static final String BOUNDARY = "----1234";
    private static final String FILE_CONTENTS = Strings.repeat((String)"1", (int)10241);
    private static String oldTmpDir;
    @Rule
    public TemporaryFolder tmpFolder = new TemporaryFolder(new File("target"));

    @BeforeClass
    public static void saveTempDir() {
        oldTmpDir = System.getProperty("java.io.tmpdir");
    }

    @AfterClass
    public static void clearTempDir() {
        if (oldTmpDir == null) {
            System.clearProperty("java.io.tmpdir");
        } else {
            System.setProperty("java.io.tmpdir", oldTmpDir);
        }
    }

    @Before
    public void initTempDir() throws Exception {
        System.setProperty("java.io.tmpdir", this.tmpFolder.getRoot().getCanonicalPath());
    }

    @Test
    public void testFormDataEmpty() throws Exception {
        this.assertEmptyDirectory(null, null);
    }

    @Test
    public void testFormDataUsingFile() throws Exception {
        this.assertEmptyDirectory("\"file1\"; filename=\"foo.txt\"", "\"file2\"; filename=\"bar.txt\"");
    }

    @Test
    public void testFormDataUsingBody() throws Exception {
        this.assertEmptyDirectory("\"junk\"", "\"body\"");
    }

    @Test
    public void testFormDataWithoutFileOrBody() throws Exception {
        this.assertEmptyDirectory("\"junk\"", "\"junk\"");
    }

    private void assertEmptyDirectory(String field1, String field2) throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest("POST", "/geoserver/ows");
        request.setContentType("multipart/form-data; boundary=----1234");
        Object content = "";
        if (field1 != null) {
            content = "------1234\r\nContent-Disposition: form-data; name=" + field1 + "\r\n\r\n" + FILE_CONTENTS + "\r\n------1234\r\nContent-Disposition: form-data; name=" + field2 + "\r\n\r\n" + FILE_CONTENTS + "\r\n------1234--\r\n";
        }
        request.setContent(((String)content).getBytes());
        URL url = this.getClass().getResource("applicationContext.xml");
        try (FileSystemXmlApplicationContext context = new FileSystemXmlApplicationContext(url.toString());){
            Dispatcher dispatcher = (Dispatcher)context.getBean("dispatcher");
            MockHttpServletResponse response = new MockHttpServletResponse();
            dispatcher.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        }
        ArrayList files = new ArrayList();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.tmpFolder.getRoot().toPath(), "upload_*.tmp");){
            stream.forEach(files::add);
        }
        MatcherAssert.assertThat((String)"Uploaded files were not deleted", files, (Matcher)Matchers.empty());
    }
}

