/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.mail.BodyPart;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.custommonkey.xmlunit.XMLUnit;
import org.geoserver.ows.AbstractDispatcherCallback;
import org.geoserver.ows.DirectInvocationService;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.HelloWorld;
import org.geoserver.ows.HttpErrorCodeException;
import org.geoserver.ows.Message;
import org.geoserver.ows.MessageXmlParser;
import org.geoserver.ows.Request;
import org.geoserver.ows.Response;
import org.geoserver.ows.TestDispatcherCallback;
import org.geoserver.platform.Operation;
import org.geoserver.platform.Service;
import org.geoserver.test.CodeExpectingHttpServletResponse;
import org.geotools.util.Version;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.springframework.mock.web.DelegatingServletInputStream;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.web.servlet.ModelAndView;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DispatcherTest {
    @Test
    public void testReadContextAndPath() throws Exception {
        Dispatcher dispatcher = new Dispatcher();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setContextPath("/geoserver");
        request.setRequestURI("/geoserver/hello");
        request.setMethod("get");
        Request req = new Request();
        req.httpRequest = request;
        dispatcher.init(req);
        Assert.assertNull((Object)req.context);
        Assert.assertEquals((Object)"hello", (Object)req.path);
        request.setRequestURI("/geoserver/foo/hello");
        dispatcher.init(req);
        Assert.assertEquals((Object)"foo", (Object)req.context);
        Assert.assertEquals((Object)"hello", (Object)req.path);
        request.setRequestURI("/geoserver/foo/baz/hello/");
        dispatcher.init(req);
        Assert.assertEquals((Object)"foo/baz", (Object)req.context);
        Assert.assertEquals((Object)"hello", (Object)req.path);
    }

    @Test
    public void testReadOpContext() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setContextPath("/geoserver");
        request.setRequestURI("/geoserver/hello");
        request.setMethod("get");
        Dispatcher dispatcher = new Dispatcher();
        Request req = new Request();
        req.httpRequest = request;
        dispatcher.init(req);
        Map map = Dispatcher.readOpContext((Request)req);
        Assert.assertEquals((Object)"hello", map.get("service"));
        request = new MockHttpServletRequest();
        request.setContextPath("/geoserver");
        request.setRequestURI("/geoserver/foobar/hello");
        request.setMethod("get");
        map = Dispatcher.readOpContext((Request)req);
        Assert.assertEquals((Object)"hello", map.get("service"));
        request = new MockHttpServletRequest();
        request.setContextPath("/geoserver");
        request.setRequestURI("/geoserver/foobar/hello/");
        request.setMethod("get");
        map = Dispatcher.readOpContext((Request)req);
        Assert.assertEquals((Object)"hello", map.get("service"));
    }

    @Test
    public void testReadOpPost() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setContextPath("/geoserver");
        request.setRequestURI("/geoserver/hello");
        request.setMethod("post");
        String body = "<Hello service=\"hello\"/>";
        DelegatingServletInputStream input = new DelegatingServletInputStream((InputStream)new ByteArrayInputStream(body.getBytes()));
        try (BufferedReader buffered = new BufferedReader(new InputStreamReader((InputStream)input));){
            buffered.mark(2048);
            Request req = new Request();
            req.setInput(buffered);
            Request res = Dispatcher.readOpPost((Request)req, (boolean)false);
            Assert.assertSame((Object)req, (Object)res);
            Assert.assertEquals((Object)"Hello", (Object)res.getRequest());
            Assert.assertEquals((Object)"hello", (Object)res.getService());
        }
    }

    @Test
    public void testReadOpPostServiceExceptions() throws Exception {
        MessageXmlParser parser = new MessageXmlParser();
        FileNotFoundException ioException = new FileNotFoundException("notFound.txt");
        SAXException saxException = new SAXException(ioException);
        SAXParseException saxParseException = new SAXParseException("glitch", "test.xsd", "test.xsd", 30, 12);
        Exception clean = parser.cleanException(ioException);
        String message = clean.getLocalizedMessage();
        Assert.assertFalse((boolean)message.contains("notFound.txt"));
        SAXException cleanSAX = parser.cleanSaxException(saxException);
        String message2 = cleanSAX.getLocalizedMessage();
        Assert.assertFalse((boolean)message2.contains("notFound.txt"));
        SAXException cleanSAXParse = parser.cleanSaxException(saxParseException);
        Assert.assertSame((Object)saxParseException, (Object)cleanSAXParse);
    }

    @Test
    public void testParseKVP() throws Exception {
        URL url = this.getClass().getResource("applicationContext.xml");
        try (FileSystemXmlApplicationContext context = new FileSystemXmlApplicationContext(url.toString());){
            Dispatcher dispatcher = (Dispatcher)context.getBean("dispatcher");
            MockHttpServletRequest request = new MockHttpServletRequest();
            request.setContextPath("/geoserver");
            request.addParameter("service", "hello");
            request.addParameter("request", "Hello");
            request.addParameter("message", "Hello world!");
            request.setQueryString("service=hello&request=hello&message=Hello World!");
            Request req = new Request();
            req.setHttpRequest((HttpServletRequest)request);
            dispatcher.parseKVP(req);
            Message message = (Message)dispatcher.parseRequestKVP(Message.class, req);
            Assert.assertEquals((Object)new Message("Hello world!"), (Object)message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testParseXML() throws Exception {
        URL url = this.getClass().getResource("applicationContext.xml");
        File file = File.createTempFile("geoserver", "req");
        try (FileSystemXmlApplicationContext context = new FileSystemXmlApplicationContext(url.toString());){
            Dispatcher dispatcher = (Dispatcher)context.getBean("dispatcher");
            String body = "<Hello service=\"hello\" message=\"Hello world!\"/>";
            try (FileOutputStream output = new FileOutputStream(file);){
                output.write(body.getBytes());
                output.flush();
            }
            try (BufferedReader input = new BufferedReader(new InputStreamReader(new FileInputStream(file)));){
                input.mark(8192);
                Request req = new Request();
                req.setInput(input);
                req.setRequest("Hello");
                req.setPostRequestElementName("Hello");
                req.setService("hello");
                Object object = dispatcher.parseRequestXML(null, input, req);
                Assert.assertEquals((Object)new Message("Hello world!"), (Object)object);
            }
        }
        finally {
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testParseXMLServiceException() throws Exception {
        URL url = this.getClass().getResource("applicationContext.xml");
        File file = File.createTempFile("geoserver", "req");
        try (FileSystemXmlApplicationContext context = new FileSystemXmlApplicationContext(url.toString());){
            Dispatcher dispatcher = (Dispatcher)context.getBean("dispatcher");
            String dtdExternal = "<!DOCTYPE foo [\n        <!ENTITY % external SYSTEM \"invalid.xsd\">\n        %external;\n        ]>";
            String body = dtdExternal + "\n<Hello service=\"hello\"/>";
            try (FileOutputStream output = new FileOutputStream(file);){
                output.write(body.getBytes());
                output.flush();
            }
            try (BufferedReader input = new BufferedReader(new InputStreamReader(new FileInputStream(file)));){
                input.mark(8192);
                Request req = new Request();
                req.setInput(input);
                req.setRequest("Hello");
                req.setPostRequestElementName("Hello");
                req.setService("hello");
                try {
                    Object request = dispatcher.parseRequestXML(null, input, req);
                    Assert.fail((String)("ServiceException expected due to invalid DTD reference:" + request));
                }
                catch (SAXException e) {
                    Assert.assertSame(e.getClass(), SAXException.class);
                    String messsage = e.getMessage();
                    Assert.assertFalse((boolean)messsage.contains("invalid.xsd"));
                }
                catch (Throwable t) {
                    Assert.fail((String)"ServiceException expected, to test use use of XmlRequestReader.cleanException(t)");
                }
            }
        }
        finally {
            file.delete();
        }
    }

    @Test
    public void testHelloOperationGet() throws Exception {
        URL url = this.getClass().getResource("applicationContext.xml");
        try (FileSystemXmlApplicationContext context = new FileSystemXmlApplicationContext(url.toString());){
            Dispatcher dispatcher = (Dispatcher)context.getBean("dispatcher");
            MockHttpServletRequest request = new MockHttpServletRequest(){
                String encoding;

                public int getServerPort() {
                    return 8080;
                }

                public String getCharacterEncoding() {
                    return this.encoding;
                }

                public void setCharacterEncoding(String encoding) {
                    this.encoding = encoding;
                }
            };
            request.setScheme("http");
            request.setServerName("localhost");
            request.setContextPath("/geoserver");
            request.setMethod("GET");
            MockHttpServletResponse response = new MockHttpServletResponse();
            request.addParameter("service", "hello");
            request.addParameter("request", "Hello");
            request.addParameter("version", "1.0.0");
            request.addParameter("message", "Hello world!");
            request.setRequestURI("http://localhost/geoserver/ows?service=hello&request=hello&message=HelloWorld");
            request.setQueryString("service=hello&request=hello&message=HelloWorld");
            dispatcher.callbacks.add(new AbstractDispatcherCallback(){

                public Object operationExecuted(Request request, Operation operation, Object result) {
                    Operation op = ((Request)Dispatcher.REQUEST.get()).getOperation();
                    Assert.assertNotNull((Object)op);
                    Assert.assertTrue((boolean)(op.getService().getService() instanceof HelloWorld));
                    Assert.assertTrue((boolean)(op.getParameters()[0] instanceof Message));
                    return result;
                }
            });
            dispatcher.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
            Assert.assertEquals((Object)"Hello world!", (Object)response.getContentAsString());
        }
    }

    @Test
    public void testHelloOperationPost() throws Exception {
        URL url = this.getClass().getResource("applicationContext.xml");
        try (FileSystemXmlApplicationContext context = new FileSystemXmlApplicationContext(url.toString());){
            Dispatcher dispatcher = (Dispatcher)context.getBean("dispatcher");
            String body = "<Hello service=\"hello\" message=\"Hello world!\" version=\"1.0.0\" />";
            MockHttpServletRequest request = new MockHttpServletRequest(){
                String encoding;

                public int getServerPort() {
                    return 8080;
                }

                public String getCharacterEncoding() {
                    return this.encoding;
                }

                public void setCharacterEncoding(String encoding) {
                    this.encoding = encoding;
                }

                public ServletInputStream getInputStream() {
                    final ServletInputStream stream = super.getInputStream();
                    return new ServletInputStream(){

                        public boolean isFinished() {
                            return stream.isFinished();
                        }

                        public boolean isReady() {
                            return stream.isReady();
                        }

                        public void setReadListener(ReadListener readListener) {
                            stream.setReadListener(readListener);
                        }

                        public int read() throws IOException {
                            return stream.read();
                        }

                        public int available() {
                            return "<Hello service=\"hello\" message=\"Hello world!\" version=\"1.0.0\" />".length();
                        }
                    };
                }
            };
            request.setScheme("http");
            request.setServerName("localhost");
            request.setContextPath("/geoserver");
            request.setMethod("POST");
            request.setRequestURI("http://localhost/geoserver/ows");
            request.setContentType("application/xml");
            request.setContent("<Hello service=\"hello\" message=\"Hello world!\" version=\"1.0.0\" />".getBytes(StandardCharsets.UTF_8));
            MockHttpServletResponse response = new MockHttpServletResponse();
            dispatcher.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
            Assert.assertEquals((Object)"Hello world!", (Object)response.getContentAsString());
        }
    }

    @Test
    public void testHelloOperationMixed() throws Exception {
        URL url = this.getClass().getResource("applicationContextOnlyXml.xml");
        try (FileSystemXmlApplicationContext context = new FileSystemXmlApplicationContext(url.toString());){
            Dispatcher dispatcher = (Dispatcher)context.getBean("dispatcher");
            String body = "<Hello service=\"hello\" message=\"Hello world!\" version=\"1.0.0\" />";
            MockHttpServletRequest request = new MockHttpServletRequest(){
                String encoding;

                public int getServerPort() {
                    return 8080;
                }

                public String getCharacterEncoding() {
                    return this.encoding;
                }

                public void setCharacterEncoding(String encoding) {
                    this.encoding = encoding;
                }

                public ServletInputStream getInputStream() {
                    final ServletInputStream stream = super.getInputStream();
                    return new ServletInputStream(){

                        public boolean isFinished() {
                            return false;
                        }

                        public boolean isReady() {
                            return false;
                        }

                        public void setReadListener(ReadListener readListener) {
                        }

                        public int read() throws IOException {
                            return stream.read();
                        }

                        public int available() {
                            return "<Hello service=\"hello\" message=\"Hello world!\" version=\"1.0.0\" />".length();
                        }
                    };
                }
            };
            request.setScheme("http");
            request.setServerName("localhost");
            request.setContextPath("/geoserver");
            request.setMethod("POST");
            request.setRequestURI("http://localhost/geoserver/ows");
            request.setContentType("application/xml");
            request.setContent("<Hello service=\"hello\" message=\"Hello world!\" version=\"1.0.0\" />".getBytes(StandardCharsets.UTF_8));
            MockHttpServletResponse response = new MockHttpServletResponse();
            request.addParameter("strict", "true");
            dispatcher.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
            Assert.assertEquals((Object)"Hello world!", (Object)response.getContentAsString());
        }
    }

    @Test
    public void testHttpErrorCodeException() throws Exception {
        this.assertHttpErrorCode("httpErrorCodeException", 204);
    }

    @Test
    public void testWrappedHttpErrorCodeException() throws Exception {
        this.assertHttpErrorCode("wrappedHttpErrorCodeException", 204);
    }

    @Test
    public void testBadRequestHttpErrorCodeException() throws Exception {
        this.assertHttpErrorCode("badRequestHttpErrorCodeException", 400);
    }

    @Test
    public void testHttpErrorCodeExceptionWithContentType() throws Exception {
        CodeExpectingHttpServletResponse rsp = this.assertHttpErrorCode("httpErrorCodeExceptionWithContentType", 200);
        Assert.assertEquals((Object)"application/json", (Object)rsp.getContentType());
    }

    private CodeExpectingHttpServletResponse assertHttpErrorCode(String requestType, int expectedCode) throws Exception {
        URL url = this.getClass().getResource("applicationContext.xml");
        try (FileSystemXmlApplicationContext context = new FileSystemXmlApplicationContext(url.toString());){
            Dispatcher dispatcher = (Dispatcher)context.getBean("dispatcher");
            MockHttpServletRequest request = new MockHttpServletRequest(){
                String encoding;

                public int getServerPort() {
                    return 8080;
                }

                public String getCharacterEncoding() {
                    return this.encoding;
                }

                public void setCharacterEncoding(String encoding) {
                    this.encoding = encoding;
                }
            };
            request.setScheme("http");
            request.setServerName("localhost");
            request.setContextPath("/geoserver");
            request.setMethod("GET");
            CodeExpectingHttpServletResponse response = new CodeExpectingHttpServletResponse((HttpServletResponse)new MockHttpServletResponse());
            request.addParameter("service", "hello");
            request.addParameter("request", requestType);
            request.addParameter("version", "1.0.0");
            request.setRequestURI("http://localhost/geoserver/ows?service=hello&request=hello&message=HelloWorld");
            request.setQueryString("service=hello&request=hello&message=HelloWorld");
            dispatcher.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
            Assert.assertEquals((long)expectedCode, (long)response.getStatusCode());
            Assert.assertEquals((Object)(expectedCode >= 400 ? 1 : 0), (Object)response.isError());
            CodeExpectingHttpServletResponse codeExpectingHttpServletResponse = response;
            return codeExpectingHttpServletResponse;
        }
    }

    @Test
    public void testDirectInvocationService() throws Throwable {
        URL url = this.getClass().getResource("applicationContext.xml");
        try (FileSystemXmlApplicationContext context = new FileSystemXmlApplicationContext(url.toString());){
            Dispatcher dispatcher = (Dispatcher)context.getBean("dispatcher");
            final AtomicBoolean invokeDirectCalled = new AtomicBoolean();
            DirectInvocationService serviceBean = new DirectInvocationService(){

                public Object invokeDirect(String operationName, Object[] parameters) throws IllegalArgumentException, Exception {
                    invokeDirectCalled.set(true);
                    if ("concat".equals(operationName)) {
                        String param1 = (String)parameters[0];
                        String param2 = (String)parameters[1];
                        return this.concat(param1, param2);
                    }
                    throw new IllegalArgumentException("Unknown operation name");
                }

                public String concat(String param1, String param2) {
                    return param1 + param2;
                }
            };
            Service service = new Service("directCallService", (Object)serviceBean, new Version("1.0.0"), Collections.singletonList("concat"));
            Method method = serviceBean.getClass().getMethod("concat", String.class, String.class);
            Object[] parameters = new Object[]{"p1", "p2"};
            Operation opDescriptor = new Operation("concat", service, method, parameters);
            Object result = dispatcher.execute(new Request(), opDescriptor);
            Assert.assertEquals((Object)"p1p2", (Object)result);
            Assert.assertTrue((boolean)invokeDirectCalled.get());
        }
    }

    @Test
    public void testDispatchWithNamespace() throws Exception {
        URL url = this.getClass().getResource("applicationContextNamespace.xml");
        try (FileSystemXmlApplicationContext context = new FileSystemXmlApplicationContext(url.toString());){
            Dispatcher dispatcher = (Dispatcher)context.getBean("dispatcher");
            MockHttpServletRequest request = new MockHttpServletRequest(){
                String encoding;

                public int getServerPort() {
                    return 8080;
                }

                public String getCharacterEncoding() {
                    return this.encoding;
                }

                public void setCharacterEncoding(String encoding) {
                    this.encoding = encoding;
                }
            };
            request.setScheme("http");
            request.setServerName("localhost");
            request.setContextPath("/geoserver");
            request.setMethod("POST");
            MockHttpServletResponse response = new MockHttpServletResponse();
            request.setContentType("application/xml");
            request.setContent("<h:Hello service='hello' message='Hello world!' xmlns:h='http://hello.org' />".getBytes(StandardCharsets.UTF_8));
            request.setRequestURI("http://localhost/geoserver/hello");
            dispatcher.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
            Assert.assertEquals((Object)"Hello world!", (Object)response.getContentAsString());
            request.setContent("<h:Hello service='hello' message='Hello world!' xmlns:h='http://hello.org/v2' />".getBytes(StandardCharsets.UTF_8));
            response = new MockHttpServletResponse();
            dispatcher.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
            Assert.assertEquals((Object)"Hello world!:V2", (Object)response.getContentAsString());
        }
    }

    public MockHttpServletRequest setupRequest() {
        MockHttpServletRequest request = new MockHttpServletRequest(){
            String encoding;

            public int getServerPort() {
                return 8080;
            }

            public String getCharacterEncoding() {
                return this.encoding;
            }

            public void setCharacterEncoding(String encoding) {
                this.encoding = encoding;
            }
        };
        request.setScheme("http");
        request.setServerName("localhost");
        request.setContextPath("/geoserver");
        request.setMethod("GET");
        request.addParameter("service", "hello");
        request.addParameter("request", "Hello");
        request.addParameter("version", "1.0.0");
        request.addParameter("message", "Hello world!");
        request.setRequestURI("http://localhost/geoserver/ows?service=hello&request=hello&message=HelloWorld");
        request.setQueryString("service=hello&request=hello&message=HelloWorld");
        return request;
    }

    @Test
    public void testDispatcherCallback() throws Exception {
        URL url = this.getClass().getResource("applicationContext.xml");
        try (FileSystemXmlApplicationContext context = new FileSystemXmlApplicationContext(url.toString());){
            Dispatcher dispatcher = (Dispatcher)context.getBean("dispatcher");
            TestDispatcherCallback callback = new TestDispatcherCallback();
            MockHttpServletRequest request = this.setupRequest();
            MockHttpServletResponse response = new MockHttpServletResponse();
            dispatcher.callbacks.add(callback);
            dispatcher.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
            Assert.assertEquals((Object)"Hello world!", (Object)response.getContentAsString());
            Assert.assertEquals((Object)((Object)TestDispatcherCallback.Status.FINISHED), (Object)((Object)callback.dispatcherStatus.get()));
        }
    }

    @Test
    public void testDispatcherCallbackFailInit() throws Exception {
        URL url = this.getClass().getResource("applicationContext.xml");
        try (FileSystemXmlApplicationContext context = new FileSystemXmlApplicationContext(url.toString());){
            Dispatcher dispatcher = (Dispatcher)context.getBean("dispatcher");
            TestDispatcherCallback callback1 = new TestDispatcherCallback();
            TestDispatcherCallback callback2 = new TestDispatcherCallback();
            TestDispatcherCallback callbackFail = new TestDispatcherCallback(){

                @Override
                public Request init(Request request) {
                    this.dispatcherStatus.set(TestDispatcherCallback.Status.INIT);
                    throw new RuntimeException("TestDispatcherCallbackFailInit");
                }
            };
            MockHttpServletRequest request = this.setupRequest();
            MockHttpServletResponse response = new MockHttpServletResponse();
            dispatcher.callbacks.add(callback1);
            dispatcher.callbacks.add(callbackFail);
            dispatcher.callbacks.add(callback2);
            dispatcher.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
            Assert.assertTrue((boolean)response.getContentAsString().contains("ows:ExceptionReport"));
            Assert.assertEquals((Object)((Object)TestDispatcherCallback.Status.FINISHED), (Object)((Object)callback1.dispatcherStatus.get()));
            Assert.assertEquals((Object)((Object)TestDispatcherCallback.Status.FINISHED), (Object)((Object)callback2.dispatcherStatus.get()));
        }
    }

    @Test
    public void testDispatcherCallbackFailServiceDispatched() throws Exception {
        URL url = this.getClass().getResource("applicationContext.xml");
        try (FileSystemXmlApplicationContext context = new FileSystemXmlApplicationContext(url.toString());){
            Dispatcher dispatcher = (Dispatcher)context.getBean("dispatcher");
            TestDispatcherCallback callback1 = new TestDispatcherCallback();
            TestDispatcherCallback callback2 = new TestDispatcherCallback();
            TestDispatcherCallback callbackFail = new TestDispatcherCallback(){

                @Override
                public Service serviceDispatched(Request request, Service service) {
                    this.dispatcherStatus.set(TestDispatcherCallback.Status.SERVICE_DISPATCHED);
                    throw new RuntimeException("TestDispatcherCallbackFailServiceDispatched");
                }
            };
            MockHttpServletRequest request = this.setupRequest();
            MockHttpServletResponse response = new MockHttpServletResponse();
            dispatcher.callbacks.add(callback1);
            dispatcher.callbacks.add(callbackFail);
            dispatcher.callbacks.add(callback2);
            dispatcher.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
            Assert.assertTrue((boolean)response.getContentAsString().contains("ows:ExceptionReport"));
            Assert.assertEquals((Object)((Object)TestDispatcherCallback.Status.FINISHED), (Object)((Object)callback1.dispatcherStatus.get()));
            Assert.assertEquals((Object)((Object)TestDispatcherCallback.Status.FINISHED), (Object)((Object)callback2.dispatcherStatus.get()));
        }
    }

    @Test
    public void testDispatcherCallbackFailOperationDispatched() throws Exception {
        URL url = this.getClass().getResource("applicationContext.xml");
        try (FileSystemXmlApplicationContext context = new FileSystemXmlApplicationContext(url.toString());){
            Dispatcher dispatcher = (Dispatcher)context.getBean("dispatcher");
            TestDispatcherCallback callback1 = new TestDispatcherCallback();
            TestDispatcherCallback callback2 = new TestDispatcherCallback();
            TestDispatcherCallback callbackFail = new TestDispatcherCallback(){

                @Override
                public Operation operationDispatched(Request request, Operation operation) {
                    this.dispatcherStatus.set(TestDispatcherCallback.Status.OPERATION_DISPATCHED);
                    throw new RuntimeException("TestDispatcherCallbackFailOperationDispatched");
                }
            };
            MockHttpServletRequest request = this.setupRequest();
            MockHttpServletResponse response = new MockHttpServletResponse();
            dispatcher.callbacks.add(callback1);
            dispatcher.callbacks.add(callbackFail);
            dispatcher.callbacks.add(callback2);
            dispatcher.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
            Assert.assertTrue((boolean)response.getContentAsString().contains("ows:ExceptionReport"));
            Assert.assertEquals((Object)((Object)TestDispatcherCallback.Status.FINISHED), (Object)((Object)callback1.dispatcherStatus.get()));
            Assert.assertEquals((Object)((Object)TestDispatcherCallback.Status.FINISHED), (Object)((Object)callback2.dispatcherStatus.get()));
        }
    }

    @Test
    public void testDispatcherCallbackFailOperationExecuted() throws Exception {
        URL url = this.getClass().getResource("applicationContext.xml");
        try (FileSystemXmlApplicationContext context = new FileSystemXmlApplicationContext(url.toString());){
            Dispatcher dispatcher = (Dispatcher)context.getBean("dispatcher");
            TestDispatcherCallback callback1 = new TestDispatcherCallback();
            TestDispatcherCallback callback2 = new TestDispatcherCallback();
            TestDispatcherCallback callbackFail = new TestDispatcherCallback(){

                @Override
                public Object operationExecuted(Request request, Operation operation, Object result) {
                    this.dispatcherStatus.set(TestDispatcherCallback.Status.OPERATION_EXECUTED);
                    throw new RuntimeException("TestDispatcherCallbackFailOperationExecuted");
                }
            };
            MockHttpServletRequest request = this.setupRequest();
            MockHttpServletResponse response = new MockHttpServletResponse();
            dispatcher.callbacks.add(callback1);
            dispatcher.callbacks.add(callbackFail);
            dispatcher.callbacks.add(callback2);
            dispatcher.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
            Assert.assertTrue((boolean)response.getContentAsString().contains("ows:ExceptionReport"));
            Assert.assertEquals((Object)((Object)TestDispatcherCallback.Status.FINISHED), (Object)((Object)callback1.dispatcherStatus.get()));
            Assert.assertEquals((Object)((Object)TestDispatcherCallback.Status.FINISHED), (Object)((Object)callback2.dispatcherStatus.get()));
        }
    }

    @Test
    public void testDispatcherCallbackFailResponseDispatched() throws Exception {
        URL url = this.getClass().getResource("applicationContext.xml");
        try (FileSystemXmlApplicationContext context = new FileSystemXmlApplicationContext(url.toString());){
            Dispatcher dispatcher = (Dispatcher)context.getBean("dispatcher");
            TestDispatcherCallback callback1 = new TestDispatcherCallback();
            TestDispatcherCallback callback2 = new TestDispatcherCallback();
            TestDispatcherCallback callbackFail = new TestDispatcherCallback(){

                @Override
                public Response responseDispatched(Request request, Operation operation, Object result, Response response) {
                    this.dispatcherStatus.set(TestDispatcherCallback.Status.RESPONSE_DISPATCHED);
                    throw new RuntimeException("TestDispatcherCallbackFailResponseDispatched");
                }
            };
            MockHttpServletRequest request = this.setupRequest();
            MockHttpServletResponse response = new MockHttpServletResponse();
            dispatcher.callbacks.add(callback1);
            dispatcher.callbacks.add(callbackFail);
            dispatcher.callbacks.add(callback2);
            dispatcher.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
            Assert.assertTrue((boolean)response.getContentAsString().contains("ows:ExceptionReport"));
            Assert.assertEquals((Object)((Object)TestDispatcherCallback.Status.FINISHED), (Object)((Object)callback1.dispatcherStatus.get()));
            Assert.assertEquals((Object)((Object)TestDispatcherCallback.Status.FINISHED), (Object)((Object)callback2.dispatcherStatus.get()));
        }
    }

    @Test
    public void testDispatcherCallbackFailFinished() throws Exception {
        URL url = this.getClass().getResource("applicationContext.xml");
        try (FileSystemXmlApplicationContext context = new FileSystemXmlApplicationContext(url.toString());){
            Dispatcher dispatcher = (Dispatcher)context.getBean("dispatcher");
            final AtomicBoolean firedCallback = new AtomicBoolean(false);
            TestDispatcherCallback callback1 = new TestDispatcherCallback();
            TestDispatcherCallback callback2 = new TestDispatcherCallback(){

                @Override
                public void finished(Request request) {
                    firedCallback.set(true);
                    super.finished(request);
                }
            };
            TestDispatcherCallback callbackFail = new TestDispatcherCallback(){

                @Override
                public void finished(Request request) {
                    this.dispatcherStatus.set(TestDispatcherCallback.Status.FINISHED);
                    throw new Error("TestDispatcherCallbackFailFinished");
                }
            };
            MockHttpServletRequest request = this.setupRequest();
            MockHttpServletResponse response = new MockHttpServletResponse();
            dispatcher.callbacks.add(callback1);
            dispatcher.callbacks.add(callbackFail);
            dispatcher.callbacks.add(callback2);
            dispatcher.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
            Assert.assertEquals((Object)"Hello world!", (Object)response.getContentAsString());
            Assert.assertTrue((boolean)firedCallback.get());
            Assert.assertEquals((Object)((Object)TestDispatcherCallback.Status.FINISHED), (Object)((Object)callback1.dispatcherStatus.get()));
            Assert.assertEquals((Object)((Object)TestDispatcherCallback.Status.FINISHED), (Object)((Object)callback2.dispatcherStatus.get()));
        }
    }

    @Test
    public void testErrorSavedOnRequestOnGenericException() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setContextPath("/geoserver");
        request.setRequestURI("/geoserver/hello");
        request.setMethod("get");
        Dispatcher dispatcher = new Dispatcher();
        Request req = new Request();
        req.httpRequest = request;
        dispatcher.init(req);
        MockHttpServletResponse response = new MockHttpServletResponse();
        req.setHttpResponse((HttpServletResponse)response);
        RuntimeException genericError = new RuntimeException("foo");
        dispatcher.exception((Throwable)genericError, null, req);
        Assert.assertEquals((String)"Exception did not get saved", (Object)genericError, (Object)req.error);
    }

    @Test
    public void testErrorSavedOnRequestOnNon304ErrorCodeException() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setContextPath("/geoserver");
        request.setRequestURI("/geoserver/hello");
        request.setMethod("get");
        Dispatcher dispatcher = new Dispatcher();
        Request req = new Request();
        req.httpRequest = request;
        dispatcher.init(req);
        MockHttpServletResponse response = new MockHttpServletResponse();
        req.setHttpResponse((HttpServletResponse)response);
        HttpErrorCodeException genericError = new HttpErrorCodeException(500, "Internal Server Error");
        dispatcher.exception((Throwable)genericError, null, req);
        Assert.assertEquals((String)"Exception did not get saved", (Object)genericError, (Object)req.error);
    }

    @Test
    public void testNoErrorOn304ErrorCodeException() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setContextPath("/geoserver");
        request.setRequestURI("/geoserver/hello");
        request.setMethod("get");
        Dispatcher dispatcher = new Dispatcher();
        Request req = new Request();
        req.httpRequest = request;
        dispatcher.init(req);
        MockHttpServletResponse response = new MockHttpServletResponse();
        req.setHttpResponse((HttpServletResponse)response);
        HttpErrorCodeException error = new HttpErrorCodeException(304, "Not Modified");
        dispatcher.exception((Throwable)error, null, req);
        Assert.assertNull((String)"Exception erroneously saved", (Object)req.error);
    }

    @Test
    public void testDispatchXMLException() throws Exception {
        URL url = this.getClass().getResource("applicationContextNamespace.xml");
        try (FileSystemXmlApplicationContext context = new FileSystemXmlApplicationContext(url.toString());){
            Dispatcher dispatcher = (Dispatcher)context.getBean("dispatcher");
            MockHttpServletRequest request = new MockHttpServletRequest(){
                String encoding;

                public int getServerPort() {
                    return 8080;
                }

                public String getCharacterEncoding() {
                    return this.encoding;
                }

                public void setCharacterEncoding(String encoding) {
                    this.encoding = encoding;
                }
            };
            request.setScheme("http");
            request.setServerName("localhost");
            request.setContextPath("/geoserver");
            request.setMethod("POST");
            MockHttpServletResponse response = new MockHttpServletResponse();
            request.setContentType("application/xml");
            request.setContent("<h:Hello xmlns:h='http:/hello.org' />".getBytes(StandardCharsets.UTF_8));
            request.setRequestURI("http://localhost/geoserver/hello");
            response = new MockHttpServletResponse();
            ModelAndView mov = dispatcher.handleRequestInternal((HttpServletRequest)request, (HttpServletResponse)response);
            Assert.assertNull((Object)mov);
            Assert.assertTrue((boolean)response.getContentAsString().contains("Could not parse the XML"));
        }
    }

    @Test
    public void testDispatchKVPException() throws Exception {
        URL url = this.getClass().getResource("applicationContext4.xml");
        try (FileSystemXmlApplicationContext context = new FileSystemXmlApplicationContext(url.toString());){
            Dispatcher dispatcher = (Dispatcher)context.getBean("dispatcher");
            MockHttpServletRequest request = new MockHttpServletRequest(){
                String encoding;

                public int getServerPort() {
                    return 8080;
                }

                public String getCharacterEncoding() {
                    return this.encoding;
                }

                public void setCharacterEncoding(String encoding) {
                    this.encoding = encoding;
                }
            };
            request.setScheme("http");
            request.setServerName("localhost");
            request.setContextPath("/geoserver");
            request.setMethod("GET");
            request.addParameter("request", "Hello");
            request.setRequestURI("http://localhost/geoserver/hello");
            request.setQueryString("message=Hello World!");
            MockHttpServletResponse response = new MockHttpServletResponse();
            response = new MockHttpServletResponse();
            ModelAndView mov = dispatcher.handleRequestInternal((HttpServletRequest)request, (HttpServletResponse)response);
            Assert.assertNull((Object)mov);
            Assert.assertTrue((boolean)response.getContentAsString().contains("Could not parse the KVP"));
        }
    }

    @Test
    public void testMultiPartFormUpload() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setContextPath("/geoserver");
        request.setRequestURI("/geoserver/hello");
        request.setMethod("post");
        String xml = "<Hello service='hello' message='Hello world!' version='1.0.0' />";
        MimeMultipart body = new MimeMultipart();
        request.setContentType(body.getContentType());
        InternetHeaders headers = new InternetHeaders();
        headers.setHeader("Content-Disposition", "form-data; name=\"upload\"; filename=\"request.xml\"");
        headers.setHeader("Content-Type", "application/xml");
        body.addBodyPart((BodyPart)new MimeBodyPart(headers, xml.getBytes()));
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        body.writeTo((OutputStream)bout);
        request.setContent(bout.toByteArray());
        MockHttpServletResponse response = new MockHttpServletResponse();
        URL url = this.getClass().getResource("applicationContext.xml");
        try (FileSystemXmlApplicationContext context = new FileSystemXmlApplicationContext(url.toString());){
            Dispatcher dispatcher = (Dispatcher)context.getBean("dispatcher");
            dispatcher.handleRequestInternal((HttpServletRequest)request, (HttpServletResponse)response);
            Assert.assertEquals((Object)"Hello world!", (Object)response.getContentAsString());
        }
    }

    @Test
    public void testMultiPartFormUploadWithBodyField() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setContextPath("/geoserver");
        request.setRequestURI("/geoserver/hello");
        request.setMethod("post");
        String xml = "<Hello service='hello' message='Hello world!' version='1.0.0' />";
        MimeMultipart body = new MimeMultipart();
        request.setContentType(body.getContentType());
        InternetHeaders headers = new InternetHeaders();
        headers.setHeader("Content-Disposition", "form-data; name=\"body\";");
        headers.setHeader("Content-Type", "application/xml");
        body.addBodyPart((BodyPart)new MimeBodyPart(headers, xml.getBytes()));
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        body.writeTo((OutputStream)bout);
        request.setContent(bout.toByteArray());
        MockHttpServletResponse response = new MockHttpServletResponse();
        URL url = this.getClass().getResource("applicationContext.xml");
        try (FileSystemXmlApplicationContext context = new FileSystemXmlApplicationContext(url.toString());){
            Dispatcher dispatcher = (Dispatcher)context.getBean("dispatcher");
            dispatcher.handleRequestInternal((HttpServletRequest)request, (HttpServletResponse)response);
            Assert.assertEquals((Object)"Hello world!", (Object)response.getContentAsString());
        }
    }

    @Test
    public void testErrorThrowingResponse() throws Exception {
        URL url = this.getClass().getResource("applicationContext-errorResponse.xml");
        try (FileSystemXmlApplicationContext context = new FileSystemXmlApplicationContext(url.toString());){
            Dispatcher dispatcher = (Dispatcher)context.getBean("dispatcher");
            MockHttpServletRequest request = this.setupRequest();
            MockHttpServletResponse response = new MockHttpServletResponse();
            dispatcher.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
            String outputContent = response.getContentAsString();
            MatcherAssert.assertThat((Object)outputContent, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"Hello world!")));
            Document dom = XMLUnit.buildTestDocument((String)outputContent);
            Assert.assertEquals((Object)"ows:ExceptionReport", (Object)dom.getDocumentElement().getNodeName());
        }
    }
}

