/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geoserver.ows.util.ClassProperties;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.ServiceException;
import org.geotools.util.SoftValueHashMap;

public class OwsUtils {
    static Map<Class, ClassProperties> classPropertiesCache = new SoftValueHashMap();

    public static void set(Object object, String property, Object value) throws IllegalArgumentException {
        String[] props = property.split("\\.");
        Method s = null;
        if (props.length > 1) {
            for (int i = 0; i < props.length - 1 && object != null; ++i) {
                object = OwsUtils.get(object, props[i]);
            }
            if (object == null) {
                throw new NullPointerException("Property '" + property + "' is null for object " + object);
            }
            s = OwsUtils.setter(object.getClass(), props[props.length - 1], value != null ? value.getClass() : null);
        } else {
            s = OwsUtils.setter(object.getClass(), property, value != null ? value.getClass() : null);
        }
        if (s == null) {
            throw new IllegalArgumentException("No such property '" + property + "' for object " + object);
        }
        try {
            s.invoke(object, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static ClassProperties classProperties(Class clazz) {
        ClassProperties properties = classPropertiesCache.get(clazz);
        if (properties == null) {
            properties = new ClassProperties(clazz);
            classPropertiesCache.put(clazz, properties);
        }
        return properties;
    }

    public static ClassProperties getClassProperties(Class clazz) {
        return OwsUtils.classProperties(clazz);
    }

    public static Method setter(Class clazz, String property, Class type) {
        return OwsUtils.classProperties(clazz).setter(property, type);
    }

    public static boolean has(Object object, String property) {
        return OwsUtils.getter(object.getClass(), property, null) != null;
    }

    public static Object get(Object object, String property) {
        String[] props = property.split("\\.");
        Object result = object;
        for (int i = 0; i < props.length && result != null; ++i) {
            String prop = props[i];
            Method g = OwsUtils.getter(result.getClass(), props[i], null);
            if (g == null) {
                throw new IllegalArgumentException("No such property '" + prop + "' for object " + result);
            }
            try {
                result = g.invoke(result, null);
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    public static void put(Object object, String property, Object key, Object value) {
        Object o = OwsUtils.get(object, property);
        if (o == null) {
            throw new NullPointerException("Property " + property + " is null");
        }
        if (!(o instanceof Map)) {
            throw new IllegalArgumentException("Property " + property + " is not a map");
        }
        ((Map)o).put(key, value);
    }

    public static Method getter(Class clazz, String property, Class type) {
        return OwsUtils.classProperties(clazz).getter(property, type);
    }

    public static <T> T property(Object object, String property, Class<T> type) {
        Method getter = OwsUtils.getter(object.getClass(), property, type);
        if (getter != null) {
            try {
                return type.cast(getter.invoke(object, (Object[])null));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static Method method(Class clazz, String name) {
        return OwsUtils.classProperties(clazz).method(name);
    }

    public static <T> T parameter(Object[] parameters, Class<T> type) {
        for (int i = 0; i < parameters.length; ++i) {
            Object parameter = parameters[i];
            if (parameter == null || !type.isAssignableFrom(parameter.getClass())) continue;
            return (T)parameter;
        }
        return null;
    }

    public static void dumpExceptionMessages(Throwable e, StringBuffer s, boolean xmlEscape) {
        Throwable ex = e;
        while (true) {
            String message;
            Throwable cause = ex.getCause();
            String lastMessage = message = ex.getMessage();
            if (message != null && !"".equals(message)) {
                if (xmlEscape) {
                    s.append(ResponseUtils.encodeXML(message));
                } else {
                    s.append(message);
                }
                if (ex instanceof ServiceException) {
                    Iterator t = ((ServiceException)ex).getExceptionText().iterator();
                    while (t.hasNext()) {
                        s.append("\n");
                        String msg = (String)t.next();
                        if (lastMessage.equals(msg)) continue;
                        if (xmlEscape) {
                            s.append(ResponseUtils.encodeXML(msg));
                        } else {
                            s.append(msg);
                        }
                        lastMessage = msg;
                    }
                }
                if (cause != null && cause.getMessage() != null && !"".equals(cause.getMessage())) {
                    s.append("\n");
                }
            }
            if (ex == cause || cause == null) break;
            ex = cause;
        }
    }

    public static <T> void copy(T source, T target, Class<T> clazz) {
        ClassProperties properties = OwsUtils.getClassProperties(clazz);
        for (String p : properties.properties()) {
            Class<?> type;
            Method setter;
            Method getter = properties.getter(p, null);
            if (getter == null || (setter = properties.setter(p, type = getter.getReturnType())) == null && !Collection.class.isAssignableFrom(type) && !Map.class.isAssignableFrom(type)) continue;
            try {
                Object newValue = getter.invoke(source, null);
                if (newValue == null) continue;
                if (setter == null) {
                    if (Collection.class.isAssignableFrom(type)) {
                        OwsUtils.updateCollectionProperty(target, (Collection)newValue, getter);
                        continue;
                    }
                    if (!Map.class.isAssignableFrom(type)) continue;
                    OwsUtils.updateMapProperty(target, (Map)newValue, getter);
                    continue;
                }
                setter.invoke(target, newValue);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void resolveCollections(Object object) {
        ClassProperties properties = OwsUtils.getClassProperties(object.getClass());
        for (String property : properties.properties()) {
            Method s;
            Class<?> type;
            Method g = properties.getter(property, null);
            if (g == null || !Map.class.isAssignableFrom(type = g.getReturnType()) && !Collection.class.isAssignableFrom(type) || (s = properties.setter(property, null)) == null) continue;
            try {
                Object value = g.invoke(object, null);
                if (value != null) continue;
                if (!type.isInterface()) {
                    try {
                        value = type.getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (value == null) {
                    if (Map.class.isAssignableFrom(type)) {
                        value = new HashMap();
                    } else if (List.class.isAssignableFrom(type)) {
                        value = new ArrayList();
                    } else if (Set.class.isAssignableFrom(type)) {
                        value = new HashSet();
                    } else {
                        throw new RuntimeException("Unknown collection type:" + type.getName());
                    }
                }
                s.invoke(object, value);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    static void updateCollectionProperty(Object object, Collection newValue, Method getter) throws Exception {
        Collection oldValue = (Collection)getter.invoke(object, null);
        if (oldValue != null) {
            oldValue.clear();
            oldValue.addAll(newValue);
        }
    }

    static void updateMapProperty(Object object, Map newValue, Method getter) throws Exception {
        Map oldValue = (Map)getter.invoke(object, null);
        if (oldValue != null) {
            oldValue.clear();
            oldValue.putAll(newValue);
        }
    }
}

