/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.xml;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.geoserver.security.xml.XMLXpathFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XMLValidator {
    public static final XMLValidator Singleton = new XMLValidator();
    protected Map<String, Schema> versionMapUR;
    protected Map<String, Schema> versionMapRR;
    private Object lockUR = new Object();
    private Object lockRR = new Object();

    protected XMLValidator() {
    }

    public void validateUserGroupRegistry(Document doc) throws IOException {
        if (this.versionMapUR == null) {
            this.initializeSchemataUR();
        }
        XPathExpression expr = XMLXpathFactory.Singleton.getVersionExpressionUR();
        String versionString = null;
        try {
            versionString = expr.evaluate(doc);
        }
        catch (XPathExpressionException e) {
            throw new IOException(e);
        }
        Schema schema = this.versionMapUR.get(versionString);
        Validator val = schema.newValidator();
        try {
            val.validate(new DOMSource(doc));
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
    }

    public void validateRoleRegistry(Document doc) throws IOException {
        String versionString;
        if (this.versionMapRR == null) {
            this.initializeSchemataRR();
        }
        XPathExpression expr = XMLXpathFactory.Singleton.getVersionExpressionRR();
        try {
            versionString = expr.evaluate(doc);
        }
        catch (XPathExpressionException e) {
            throw new IOException(e);
        }
        Schema schema = this.versionMapRR.get(versionString);
        Validator val = schema.newValidator();
        try {
            val.validate(new DOMSource(doc));
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeSchemataUR() throws IOException {
        Object object = this.lockUR;
        synchronized (object) {
            if (this.versionMapUR != null) {
                return;
            }
            this.versionMapUR = new HashMap<String, Schema>();
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = null;
            try {
                schema = factory.newSchema(this.getClass().getResource("users.xsd"));
            }
            catch (SAXException e) {
                throw new IOException(e);
            }
            this.versionMapUR.put("1.0", schema);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeSchemataRR() throws IOException {
        Object object = this.lockRR;
        synchronized (object) {
            if (this.versionMapRR != null) {
                return;
            }
            this.versionMapRR = new HashMap<String, Schema>();
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = null;
            try {
                schema = factory.newSchema(this.getClass().getResource("roles.xsd"));
            }
            catch (SAXException e) {
                throw new IOException(e);
            }
            this.versionMapRR.put("1.0", schema);
        }
    }
}

