/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.geoserver.platform.resource.Files;
import org.geoserver.platform.resource.Resource;
import org.geoserver.security.GeoServerRoleStore;
import org.geoserver.security.config.FileBasedSecurityServiceConfig;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.impl.AbstractRoleService;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.xml.RoleXMLXpath;
import org.geoserver.security.xml.XMLRoleStore;
import org.geoserver.security.xml.XMLSecurityServiceConfig;
import org.geoserver.security.xml.XMLValidator;
import org.geoserver.security.xml.XMLXpathFactory;
import org.geoserver.util.IOUtils;
import org.geotools.util.logging.Logging;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLRoleService
extends AbstractRoleService {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.security.xml");
    protected DocumentBuilder builder;
    protected Resource roleResource;
    private boolean validatingXMLSchema = true;

    public XMLRoleService() throws IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setIgnoringComments(true);
        try {
            this.builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void initializeFromConfig(SecurityNamedServiceConfig config) throws IOException {
        super.initializeFromConfig(config);
        this.validatingXMLSchema = false;
        if (config instanceof XMLSecurityServiceConfig) {
            this.validatingXMLSchema = ((XMLSecurityServiceConfig)config).isValidating();
            Resource xsdFile = this.getConfigRoot().get("roles.xsd");
            if (xsdFile.getType() == Resource.Type.UNDEFINED) {
                IOUtils.copy((InputStream)this.getClass().getResourceAsStream("roles.xsd"), (OutputStream)xsdFile.out());
            }
        }
        if (config instanceof FileBasedSecurityServiceConfig) {
            String fileName = ((FileBasedSecurityServiceConfig)config).getFileName();
            File roleFile = new File(fileName);
            this.roleResource = roleFile.isAbsolute() ? Files.asResource((File)roleFile) : this.getConfigRoot().get(fileName);
            if (this.roleResource.getType() == Resource.Type.UNDEFINED) {
                IOUtils.copy((InputStream)this.getClass().getResourceAsStream("rolesTemplate.xml"), (OutputStream)this.roleResource.out());
            }
        } else {
            throw new IOException("Cannot initialize from " + config.getClass().getName());
        }
        this.deserialize();
    }

    @Override
    public boolean canCreateStore() {
        return true;
    }

    @Override
    public GeoServerRoleStore createStore() throws IOException {
        XMLRoleStore store = new XMLRoleStore();
        store.initializeFromService(this);
        return store;
    }

    public boolean isValidatingXMLSchema() {
        return this.validatingXMLSchema;
    }

    public void setValidatingXMLSchema(boolean validatingXMLSchema) {
        this.validatingXMLSchema = validatingXMLSchema;
    }

    @Override
    protected void deserialize() throws IOException {
        try {
            String roleName;
            Node roleNode;
            int i;
            Document doc = null;
            try (InputStream is = this.roleResource.in();){
                doc = this.builder.parse(is);
            }
            catch (SAXException e) {
                throw new IOException(e);
            }
            if (this.isValidatingXMLSchema()) {
                XMLValidator.Singleton.validateRoleRegistry(doc);
            }
            XPathExpression expr = XMLXpathFactory.Singleton.getVersionExpressionRR();
            String versioNumber = expr.evaluate(doc);
            RoleXMLXpath xmlXPath = XMLXpathFactory.Singleton.getRoleXMLXpath(versioNumber);
            this.clearMaps();
            NodeList roleNodes = (NodeList)xmlXPath.getRoleListExpression().evaluate(doc, XPathConstants.NODESET);
            for (i = 0; i < roleNodes.getLength(); ++i) {
                roleNode = roleNodes.item(i);
                roleName = xmlXPath.getRoleNameExpression().evaluate(roleNode);
                NodeList propertyNodes = (NodeList)xmlXPath.getRolePropertiesExpression().evaluate(roleNode, XPathConstants.NODESET);
                Properties roleProps = new Properties();
                for (int j = 0; j < propertyNodes.getLength(); ++j) {
                    Node propertyNode = propertyNodes.item(j);
                    String string = xmlXPath.getPropertyNameExpression().evaluate(propertyNode);
                    String propertyValue = xmlXPath.getPropertyValueExpression().evaluate(propertyNode);
                    roleProps.put(string, propertyValue);
                }
                GeoServerRole role = this.createRoleObject(roleName);
                role.getProperties().clear();
                for (Object e : roleProps.keySet()) {
                    role.getProperties().put(e, roleProps.get(e));
                }
                this.helper.roleMap.put(roleName, role);
            }
            for (i = 0; i < roleNodes.getLength(); ++i) {
                roleNode = roleNodes.item(i);
                roleName = xmlXPath.getRoleNameExpression().evaluate(roleNode);
                String parentName = xmlXPath.getParentExpression().evaluate(roleNode);
                if (parentName == null || parentName.isEmpty()) continue;
                this.helper.role_parentMap.put(this.helper.roleMap.get(roleName), this.helper.roleMap.get(parentName));
            }
            NodeList userRolesNodes = (NodeList)xmlXPath.getUserRolesExpression().evaluate(doc, XPathConstants.NODESET);
            for (int i2 = 0; i2 < userRolesNodes.getLength(); ++i2) {
                Node userRolesNode = userRolesNodes.item(i2);
                String userName = xmlXPath.getUserNameExpression().evaluate(userRolesNode);
                TreeSet<GeoServerRole> roleSet = new TreeSet<GeoServerRole>();
                this.helper.user_roleMap.put(userName, roleSet);
                NodeList userRolesRefNodes = (NodeList)xmlXPath.getUserRolRefsExpression().evaluate(userRolesNode, XPathConstants.NODESET);
                for (int j = 0; j < userRolesRefNodes.getLength(); ++j) {
                    Node node = userRolesRefNodes.item(j);
                    String roleRef = xmlXPath.getUserRolRefNameExpression().evaluate(node);
                    roleSet.add(this.helper.roleMap.get(roleRef));
                }
            }
            NodeList groupRolesNodes = (NodeList)xmlXPath.getGroupRolesExpression().evaluate(doc, XPathConstants.NODESET);
            for (int i3 = 0; i3 < groupRolesNodes.getLength(); ++i3) {
                Node groupRolesNode = groupRolesNodes.item(i3);
                String groupName = xmlXPath.getGroupNameExpression().evaluate(groupRolesNode);
                TreeSet<GeoServerRole> roleSet = new TreeSet<GeoServerRole>();
                this.helper.group_roleMap.put(groupName, roleSet);
                NodeList groupRolesRefNodes = (NodeList)xmlXPath.getGroupRolRefsExpression().evaluate(groupRolesNode, XPathConstants.NODESET);
                for (int j = 0; j < groupRolesRefNodes.getLength(); ++j) {
                    Node groupRolesRefNode = groupRolesRefNodes.item(j);
                    String roleRef = xmlXPath.getGroupRolRefNameExpression().evaluate(groupRolesRefNode);
                    roleSet.add(this.helper.roleMap.get(roleRef));
                }
            }
        }
        catch (XPathExpressionException ex) {
            throw new IOException(ex);
        }
    }
}

