/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.urlchecks;

import java.io.Serializable;
import java.util.Objects;
import org.geoserver.security.urlchecks.AbstractURLCheck;

public class RegexURLCheck
extends AbstractURLCheck
implements Serializable {
    private String regex;

    public RegexURLCheck() {
    }

    public RegexURLCheck(String name, String description, String regex) {
        this.name = name;
        this.description = description;
        this.regex = regex;
    }

    public String getRegex() {
        return this.regex;
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegexURLCheck that = (RegexURLCheck)o;
        return this.enabled == that.enabled && Objects.equals(this.name, that.name) && Objects.equals(this.description, that.description) && Objects.equals(this.regex, that.regex);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.regex, this.enabled);
    }

    public String toString() {
        return "RegexUrlCheck{name='" + this.name + "', description='" + this.description + "', regex='" + this.regex + "', enabled=" + this.enabled + "}";
    }

    public boolean confirm(String location) {
        return location.matches(this.regex);
    }

    @Override
    public String getConfiguration() {
        return this.getRegex();
    }
}

