/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geoserver.security.WMSAccessLimits;
import org.geoserver.security.WrapperPolicy;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.GeneralBounds;
import org.geotools.ows.wms.CRSEnvelope;
import org.geotools.ows.wms.Layer;
import org.geotools.ows.wms.StyleImpl;
import org.geotools.ows.wms.xml.Dimension;
import org.geotools.ows.wms.xml.Extent;

public class SecuredWMSLayer
extends Layer {
    Layer delegate;
    WrapperPolicy policy;

    public SecuredWMSLayer(Layer delegate, WrapperPolicy policy) {
        this.delegate = delegate;
        this.policy = policy;
    }

    public WrapperPolicy getPolicy() {
        return this.policy;
    }

    public boolean isQueryable() {
        WMSAccessLimits wl;
        if (this.policy.getLimits() instanceof WMSAccessLimits && !(wl = (WMSAccessLimits)this.policy.getLimits()).isAllowFeatureInfo()) {
            return false;
        }
        return this.delegate.isQueryable();
    }

    public String toString() {
        return "SecuredLayer - " + this.delegate.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.delegate == null ? 0 : this.delegate.hashCode());
        result = 31 * result + (this.policy == null ? 0 : this.policy.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        SecuredWMSLayer other = (SecuredWMSLayer)((Object)obj);
        if (this.delegate == null ? other.delegate != null : !this.delegate.equals(other.delegate)) {
            return false;
        }
        return !(this.policy == null ? other.policy != null : !this.policy.equals(other.policy));
    }

    public void addChildren(Layer child) {
        this.delegate.addChildren(child);
    }

    public void clearCache() {
        this.delegate.clearCache();
    }

    public int compareTo(Layer layer) {
        return this.delegate.compareTo(layer);
    }

    public String get_abstract() {
        return this.delegate.get_abstract();
    }

    public Map<String, CRSEnvelope> getBoundingBoxes() {
        return this.delegate.getBoundingBoxes();
    }

    public Layer[] getChildren() {
        return this.delegate.getChildren();
    }

    public Dimension getDimension(String name) {
        return this.delegate.getDimension(name);
    }

    public Map<String, Dimension> getDimensions() {
        return this.delegate.getDimensions();
    }

    public GeneralBounds getEnvelope(CoordinateReferenceSystem crs) {
        return this.delegate.getEnvelope(crs);
    }

    public Extent getExtent(String name) {
        return this.delegate.getExtent(name);
    }

    public Map<String, Extent> getExtents() {
        return this.delegate.getExtents();
    }

    public String[] getKeywords() {
        return this.delegate.getKeywords();
    }

    public CRSEnvelope getLatLonBoundingBox() {
        return this.delegate.getLatLonBoundingBox();
    }

    public List<CRSEnvelope> getLayerBoundingBoxes() {
        return this.delegate.getLayerBoundingBoxes();
    }

    public List<Layer> getLayerChildren() {
        return this.delegate.getLayerChildren();
    }

    public List<Dimension> getLayerDimensions() {
        return this.delegate.getLayerDimensions();
    }

    public List<Extent> getLayerExtents() {
        return this.delegate.getLayerExtents();
    }

    public String getName() {
        return this.delegate.getName();
    }

    public Layer getParent() {
        return this.delegate.getParent();
    }

    public double getScaleDenominatorMax() {
        return this.delegate.getScaleDenominatorMax();
    }

    public double getScaleDenominatorMin() {
        return this.delegate.getScaleDenominatorMin();
    }

    public double getScaleHintMax() {
        return this.delegate.getScaleDenominatorMax();
    }

    public double getScaleHintMin() {
        return this.delegate.getScaleDenominatorMin();
    }

    public Set<String> getSrs() {
        return this.delegate.getSrs();
    }

    public List<StyleImpl> getStyles() {
        return this.delegate.getStyles();
    }

    public String getTitle() {
        return this.delegate.getTitle();
    }

    public void set_abstract(String abstract1) {
        this.delegate.set_abstract(abstract1);
    }

    public void setBoundingBoxes(CRSEnvelope boundingBox) {
        this.delegate.setBoundingBoxes(boundingBox);
    }

    public void setBoundingBoxes(Map<String, CRSEnvelope> boundingBoxes) {
        this.delegate.setBoundingBoxes(boundingBoxes);
    }

    public void setChildren(Layer[] childrenArray) {
        this.delegate.setChildren(childrenArray);
    }

    public void setDimensions(Collection<Dimension> dimensionList) {
        this.delegate.setDimensions(dimensionList);
    }

    public void setDimensions(Dimension dimension) {
        this.delegate.setDimensions(dimension);
    }

    public void setDimensions(Map<String, Dimension> dimensionMap) {
        this.delegate.setDimensions(dimensionMap);
    }

    public void setExtents(Collection<Extent> extentList) {
        this.delegate.setExtents(extentList);
    }

    public void setExtents(Extent extent) {
        this.delegate.setExtents(extent);
    }

    public void setExtents(Map<String, Extent> extentMap) {
        this.delegate.setExtents(extentMap);
    }

    public void setKeywords(String[] keywords) {
        this.delegate.setKeywords(keywords);
    }

    public void setLatLonBoundingBox(CRSEnvelope latLonBoundingBox) {
        this.delegate.setLatLonBoundingBox(latLonBoundingBox);
    }

    public void setName(String name) {
        this.delegate.setName(name);
    }

    public void setParent(Layer parentLayer) {
        this.delegate.setParent(parentLayer);
    }

    public void setQueryable(boolean queryable) {
        this.delegate.setQueryable(queryable);
    }

    public void setScaleDenominatorMax(double scaleDenominatorMax) {
        this.delegate.setScaleDenominatorMax(scaleDenominatorMax);
    }

    public void setScaleDenominatorMin(double scaleDenominatorMin) {
        this.delegate.setScaleDenominatorMin(scaleDenominatorMin);
    }

    public void setScaleHintMax(double scaleHintMax) {
        this.delegate.setScaleDenominatorMax(scaleHintMax);
    }

    public void setScaleHintMin(double scaleHintMin) {
        this.delegate.setScaleDenominatorMin(scaleHintMin);
    }

    public void setSrs(Set<String> srs) {
        this.delegate.setSrs(srs);
    }

    public void setStyles(List<StyleImpl> styles) {
        this.delegate.setStyles(styles);
    }

    public void setTitle(String title) {
        this.delegate.setTitle(title);
    }
}

