/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.Predicates;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.Request;
import org.geoserver.security.AbstractCatalogFilter;
import org.geotools.api.filter.Filter;

public class DisabledResourceFilter
extends AbstractCatalogFilter {
    private boolean shouldApplyFilter() {
        Request request = (Request)Dispatcher.REQUEST.get();
        return request != null && request.getService() != null && request.getRequest() != null;
    }

    @Override
    public Filter getSecurityFilter(Class<? extends CatalogInfo> clazz) {
        if (this.shouldApplyFilter()) {
            if (LayerInfo.class.isAssignableFrom(clazz)) {
                return Predicates.and(Predicates.equal("enabled", true), Predicates.equal("resource.enabled", true), Predicates.equal("resource.store.enabled", true));
            }
            if (ResourceInfo.class.isAssignableFrom(clazz)) {
                return Predicates.and(Predicates.equal("enabled", true), Predicates.equal("store.enabled", true));
            }
        }
        return Filter.INCLUDE;
    }

    @Override
    public boolean hideLayer(LayerInfo layer) {
        if (this.shouldApplyFilter()) {
            return !layer.enabled();
        }
        return false;
    }

    @Override
    public boolean hideLayerGroup(LayerGroupInfo layerGroup) {
        if (this.shouldApplyFilter()) {
            return !layerGroup.isEnabled();
        }
        return false;
    }

    @Override
    public boolean hideResource(ResourceInfo resource) {
        if (this.shouldApplyFilter()) {
            return !resource.enabled();
        }
        return false;
    }
}

