/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.ows.DispatcherCallback;
import org.geoserver.ows.LocalPublished;
import org.geoserver.ows.LocalWorkspace;
import org.geoserver.ows.Request;
import org.geoserver.ows.Response;
import org.geoserver.platform.ExtensionPriority;
import org.geoserver.platform.Operation;
import org.geoserver.platform.Service;
import org.geoserver.platform.ServiceException;
import org.geotools.api.feature.type.Name;
import org.geotools.feature.NameImpl;
import org.geotools.util.SuppressFBWarnings;
import org.geotools.util.logging.Logging;

public class LocalWorkspaceCallback
implements DispatcherCallback,
ExtensionPriority {
    static final Logger LOGGER = Logging.getLogger(LocalWorkspaceCallback.class);
    GeoServer gs;

    public LocalWorkspaceCallback(GeoServer gs) {
        this.gs = gs;
    }

    @SuppressFBWarnings(value={"NP_NONNULL_PARAM_VIOLATION"})
    public Request init(Request request) {
        WorkspaceInfo ws = null;
        LayerGroupInfo lg = null;
        if (request.context != null) {
            Catalog catalog;
            String first = request.context;
            String last = null;
            int slash = first.indexOf(47);
            if (slash > -1) {
                last = first.substring(slash + 1);
                first = first.substring(0, slash);
            }
            if ((ws = (catalog = this.gs.getCatalog()).getWorkspaceByName(first)) != null) {
                NamespaceInfo ns;
                LocalWorkspace.set(ws);
                if (last != null && (ns = catalog.getNamespaceByPrefix(ws.getName())) != null) {
                    LayerInfo l;
                    int slashInLayer = last.indexOf(47);
                    if (slashInLayer != -1) {
                        last = last.substring(0, slashInLayer);
                    }
                    if ((l = catalog.getLayerByName((Name)new NameImpl(ns.getURI(), last))) != null) {
                        LocalPublished.set(l);
                    } else {
                        LOGGER.log(Level.FINE, "Could not lookup context {0} as a layer, trying as group", first);
                        lg = catalog.getLayerGroupByName(ws, last);
                        if (lg != null) {
                            LocalPublished.set(lg);
                        } else {
                            LOGGER.log(Level.FINE, "Could not lookup context {0} as a group either", first);
                        }
                    }
                }
            } else {
                LOGGER.log(Level.FINE, "Could not lookup context {0} as a workspace, trying as group", first);
                lg = catalog.getLayerGroupByName((WorkspaceInfo)null, first);
                if (lg != null) {
                    LocalPublished.set(lg);
                } else {
                    LOGGER.log(Level.FINE, "Could not lookup context {0} as a layer group either", first);
                }
            }
            if (ws == null && lg == null && !this.gs.getGlobal().isGlobalServices().booleanValue()) {
                throw new ServiceException("Could not determine workspace or workspace/layer-or-layergroup from request: '" + request.context + "', and global services are off.");
            }
        } else if (!this.gs.getGlobal().isGlobalServices().booleanValue()) {
            throw new ServiceException("No workspace specified");
        }
        return request;
    }

    public Operation operationDispatched(Request request, Operation operation) {
        return null;
    }

    public Object operationExecuted(Request request, Operation operation, Object result) {
        return null;
    }

    public Response responseDispatched(Request request, Operation operation, Object result, Response response) {
        return null;
    }

    public Service serviceDispatched(Request request, Service service) throws ServiceException {
        return null;
    }

    public void finished(Request request) {
        LocalWorkspace.remove();
        LocalPublished.remove();
    }

    public int getPriority() {
        return 0;
    }
}

