/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.geoserver.ows.AbstractDispatcherCallback;
import org.geoserver.ows.Request;
import org.geotools.filter.function.EnvFunction;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class EnviromentInjectionCallback
extends AbstractDispatcherCallback {
    private static final Set<String> BLOCKED_VARIABLES = Set.of("GSUSER");

    public Request init(Request request) {
        Authentication auth;
        HashMap<String, String> envVars;
        Object obj = request.getKvp().get("env");
        HashMap<String, String> hashMap = envVars = obj instanceof Map ? (HashMap<String, String>)obj : null;
        if (envVars != null) {
            envVars.keySet().removeIf(key -> BLOCKED_VARIABLES.contains(key.toUpperCase()));
        }
        if ((auth = SecurityContextHolder.getContext().getAuthentication()) != null && !(auth instanceof AnonymousAuthenticationToken)) {
            String name = auth.getName();
            if (envVars == null) {
                envVars = new HashMap<String, String>();
            }
            envVars.put("GSUSER", name);
        }
        if (envVars != null) {
            EnvFunction.setLocalValues((Map)envVars);
        }
        return request;
    }

    public void finished(Request request) {
        EnvFunction.clearLocalValues();
    }
}

