/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.filters;

import java.io.IOException;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

class FlushSafeResponse
extends HttpServletResponseWrapper
implements HttpServletResponse {
    ServletOutputStream os = null;

    public FlushSafeResponse(HttpServletResponse response) {
        super(response);
    }

    public synchronized ServletOutputStream getOutputStream() throws IOException {
        if (this.os == null) {
            this.os = new FlushSafeServletOutputStream(super.getOutputStream());
        }
        return this.os;
    }

    static class FlushSafeServletOutputStream
    extends ServletOutputStream {
        ServletOutputStream delegate;
        boolean closed = false;

        public FlushSafeServletOutputStream(ServletOutputStream delegate) {
            this.delegate = delegate;
        }

        public void write(int b) throws IOException {
            this.delegate.write(b);
        }

        public void write(byte[] b) throws IOException {
            this.delegate.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.delegate.write(b, off, len);
        }

        public void flush() throws IOException {
            if (!this.closed) {
                this.delegate.flush();
            }
        }

        public void close() throws IOException {
            this.closed = true;
            this.delegate.close();
        }

        public boolean isReady() {
            return this.delegate.isReady();
        }

        public void setWriteListener(WriteListener writeListener) {
            this.delegate.setWriteListener(writeListener);
        }
    }
}

