/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.filters;

import java.io.IOException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.filters.GZIPResponseStream;
import org.geotools.util.logging.Logging;

public class AlternativesResponseStream
extends ServletOutputStream {
    HttpServletResponse myResponse;
    ServletOutputStream myStream;
    Set myCompressibleTypes;
    Logger logger = Logging.getLogger((String)"org.geoserver.filters");
    long contentLength;

    public AlternativesResponseStream(HttpServletResponse response, Set compressible, long contentLength) throws IOException {
        this.myResponse = response;
        this.myCompressibleTypes = compressible;
        this.contentLength = contentLength;
    }

    public void close() throws IOException {
        if (this.isDirty()) {
            this.getStream().close();
        }
    }

    public void flush() throws IOException {
        if (this.isDirty()) {
            this.getStream().flush();
        }
    }

    public void write(int b) throws IOException {
        this.getStream().write(b);
    }

    public void write(byte[] b) throws IOException {
        this.getStream().write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.getStream().write(b, off, len);
    }

    protected ServletOutputStream getStream() throws IOException {
        if (this.myStream != null) {
            return this.myStream;
        }
        String type = this.myResponse.getContentType();
        if (type != null && this.isCompressible(type)) {
            this.logger.log(Level.FINE, "Compressing output for mimetype: {0}", type);
            this.myResponse.addHeader("Content-Encoding", "gzip");
            this.myStream = new GZIPResponseStream(this.myResponse);
        } else {
            this.logger.log(Level.FINE, "Not compressing output for mimetype: {0}", type);
            if (this.contentLength >= 0L) {
                this.myResponse.setContentLengthLong(this.contentLength);
            }
            this.myStream = this.myResponse.getOutputStream();
        }
        return this.myStream;
    }

    protected boolean isDirty() {
        return this.myStream != null;
    }

    protected boolean isCompressible(String mimetype) {
        String stripped = this.stripParams(mimetype);
        for (Pattern pat : this.myCompressibleTypes) {
            Matcher matcher = pat.matcher(stripped);
            if (!matcher.matches()) continue;
            return true;
        }
        return false;
    }

    protected String stripParams(String mimetype) {
        int firstSemicolon = mimetype.indexOf(";");
        if (firstSemicolon != -1) {
            return mimetype.substring(0, firstSemicolon);
        }
        return mimetype;
    }

    public boolean isReady() {
        return this.myStream.isReady();
    }

    public void setWriteListener(WriteListener writeListener) {
        this.myStream.setWriteListener(writeListener);
    }
}

