/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config.util;

import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.mapper.Mapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;

public class CollectionConverter
extends com.thoughtworks.xstream.converters.collections.CollectionConverter {
    public static final String UNMODIFIABLE_LIST = "java.util.Collections$UnmodifiableList";
    public static final String UNMODIFIABLE_SET = "java.util.Collections$UnmodifiableSet";
    public static final String ARRAY_LIST = "java.util.Arrays$ArrayList";

    public CollectionConverter(Mapper mapper) {
        super(mapper);
    }

    public CollectionConverter(Mapper mapper, Class<?> type) {
        super(mapper, type);
    }

    public boolean canConvert(Class type) {
        String typeName;
        if (type != null && ((typeName = type.getName()).equals(ARRAY_LIST) || typeName.equals(UNMODIFIABLE_LIST) || typeName.equals(UNMODIFIABLE_SET))) {
            return true;
        }
        return super.canConvert(type);
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Class requiredType = context.getRequiredType();
        if (requiredType != null) {
            String typeName = requiredType.getName();
            if (UNMODIFIABLE_LIST.equals(typeName)) {
                ArrayList list2 = new ArrayList();
                this.populateCollection(reader, context, list2);
                return Collections.unmodifiableList(list2);
            }
            if (UNMODIFIABLE_SET.equals(typeName)) {
                HashSet set = new HashSet();
                this.populateCollection(reader, context, set);
                return Collections.unmodifiableSet(set);
            }
            if (ARRAY_LIST.equals(typeName)) {
                ArrayList list3 = new ArrayList();
                this.populateCollection(reader, context, list3);
                return Arrays.asList(list3.toArray());
            }
        }
        return super.unmarshal(reader, context);
    }
}

