/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config.datadir;

import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.platform.GeoServerExtensions;
import org.geotools.util.logging.Logging;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.StringUtils;

class ExecutorFactory {
    private static final Logger LOGGER = Logging.getLogger((String)ExecutorFactory.class.getPackage().getName());
    private static final AtomicInteger threadPoolId = new AtomicInteger();

    private ExecutorFactory() {
    }

    public static ForkJoinPool createExecutor(Authentication admin) {
        int parallelism = ExecutorFactory.determineParallelism();
        boolean asyncMode = false;
        return new ForkJoinPool(parallelism, ExecutorFactory.threadFactory(admin), ExecutorFactory.uncaughtExceptionHandler(), false);
    }

    private static ForkJoinPool.ForkJoinWorkerThreadFactory threadFactory(Authentication admin) {
        int poolIndex = threadPoolId.incrementAndGet();
        AtomicInteger threadIndex = new AtomicInteger();
        return pool -> {
            SecurityContextHolder.getContext().setAuthentication(admin);
            ForkJoinWorkerThread worker = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool);
            worker.setName(String.format("DatadirLoader-%d-worker-%d", poolIndex, threadIndex.incrementAndGet()));
            return worker;
        };
    }

    private static Thread.UncaughtExceptionHandler uncaughtExceptionHandler() {
        return (t, ex) -> {
            String msg = String.format("Uncaught exception loading catalog or config at thread %s: %s", t.getName(), ex.getMessage());
            LOGGER.log(Level.SEVERE, msg, ex);
        };
    }

    static int determineParallelism() {
        int defParallelism;
        String configuredParallelism = GeoServerExtensions.getProperty((String)"GEOSERVER_DATA_DIR_LOADER_THREADS");
        int processors = Runtime.getRuntime().availableProcessors();
        int parallelism = defParallelism = Math.min(processors, 16);
        Object logTailMessage = "out of " + processors + " available cores.";
        if (StringUtils.hasText((String)configuredParallelism)) {
            boolean parseFail = false;
            try {
                parallelism = Integer.parseInt(configuredParallelism);
            }
            catch (NumberFormatException nfe) {
                parseFail = true;
            }
            if (parseFail || parallelism < 1) {
                parallelism = defParallelism;
                LOGGER.log(Level.WARNING, () -> String.format("Configured parallelism is invalid: %s=%s, using default of %d", "GEOSERVER_DATA_DIR_LOADER_THREADS", configuredParallelism, defParallelism));
            } else if (parallelism > processors) {
                parallelism = processors;
                LOGGER.log(Level.WARNING, () -> String.format("Configured parallelism is invalid: %s=%s, using maximum of %d as per available processors", "GEOSERVER_DATA_DIR_LOADER_THREADS", configuredParallelism, defParallelism));
            } else {
                logTailMessage = "as indicated by the GEOSERVER_DATA_DIR_LOADER_THREADS environment variable or System property";
            }
        }
        LOGGER.log(Level.CONFIG, "Catalog and configuration loader uses {0} threads {1}", new Object[]{parallelism, logTailMessage});
        return parallelism;
    }
}

