/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogException;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.event.CatalogAddEvent;
import org.geoserver.catalog.event.CatalogListener;
import org.geoserver.catalog.event.CatalogModifyEvent;
import org.geoserver.catalog.event.CatalogPostModifyEvent;
import org.geoserver.catalog.event.CatalogRemoveEvent;
import org.geoserver.catalog.impl.ResolvingProxy;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.Resources;
import org.geotools.util.logging.Logging;

public class GeoServerResourcePersister
implements CatalogListener {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.config");
    Catalog catalog;
    GeoServerResourceLoader rl;
    GeoServerDataDirectory dd;

    public GeoServerResourcePersister(Catalog catalog) {
        this.catalog = catalog;
        this.rl = catalog.getResourceLoader();
        this.dd = new GeoServerDataDirectory(this.rl);
    }

    @Override
    public void handleAddEvent(CatalogAddEvent event) throws CatalogException {
    }

    @Override
    public void handlePostModifyEvent(CatalogPostModifyEvent event) throws CatalogException {
    }

    @Override
    public void reloaded() {
    }

    @Override
    public void handleModifyEvent(CatalogModifyEvent event) {
        CatalogInfo source = event.getSource();
        try {
            int i;
            if (source instanceof StyleInfo && (i = event.getPropertyNames().indexOf("workspace")) > -1) {
                WorkspaceInfo oldWorkspace = (WorkspaceInfo)event.getOldValues().get(i);
                WorkspaceInfo newWorkspace = ResolvingProxy.resolve(this.catalog, (WorkspaceInfo)event.getNewValues().get(i));
                Resource oldDir = this.dd.getStyles(oldWorkspace, new String[0]);
                Resource newDir = this.dd.getStyles(newWorkspace, new String[0]);
                URI oldDirURI = new URI(oldDir.path());
                for (Resource old : this.dd.additionalStyleResources((StyleInfo)source)) {
                    if (old.getType() == Resource.Type.UNDEFINED) continue;
                    URI oldURI = new URI(old.path());
                    URI relative = oldDirURI.relativize(oldURI);
                    Resource target = newDir.get(relative.getPath()).parent();
                    this.copyResToDir(old, target);
                }
                for (Resource old : this.baseResources((StyleInfo)source)) {
                    if (old.getType() == Resource.Type.UNDEFINED) continue;
                    this.moveResToDir(old, newDir);
                }
            }
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void handleRemoveEvent(CatalogRemoveEvent event) {
        CatalogInfo source = event.getSource();
        try {
            if (source instanceof StyleInfo) {
                this.removeStyle((StyleInfo)source);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void removeStyle(StyleInfo s) throws IOException {
        Resource sld = this.dd.style(s);
        if (Resources.exists((Resource)sld) && sld.getType() == Resource.Type.RESOURCE) {
            Resource sldBackup = this.dd.get(sld.path() + ".bak");
            int i = 1;
            while (Resources.exists((Resource)sldBackup)) {
                sldBackup = this.dd.get(sld.path() + ".bak." + i++);
            }
            LOGGER.fine("Removing the SLD as well but making backup " + sldBackup.name());
            sld.renameTo(sldBackup);
        }
    }

    private List<Resource> baseResources(StyleInfo s) throws IOException {
        List<Resource> list2 = Arrays.asList(this.dd.config(s), this.dd.style(s));
        return list2;
    }

    private void moveResToDir(Resource r, Resource newDir) {
        this.rl.move(r.path(), newDir.get(r.name()).path());
    }

    private void copyResToDir(Resource r, Resource newDir) throws IOException {
        Resource newR = newDir.get(r.name());
        try (InputStream in = r.in();
             OutputStream out = newR.out();){
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
    }
}

