/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config;

import java.util.Objects;
import org.geoserver.GeoServerConfigurationLock;
import org.geoserver.config.DefaultGeoServerLoader;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.config.GeoServerLoader;
import org.geoserver.config.GeoServerReinitializer;
import org.geoserver.config.datadir.DataDirectoryGeoServerLoader;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.security.GeoServerSecurityManager;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;

public class GeoServerLoaderProxy
implements BeanPostProcessor,
ApplicationListener<ContextClosedEvent>,
ApplicationContextAware,
GeoServerReinitializer {
    protected GeoServerResourceLoader resourceLoader;
    GeoServerLoader loader;

    public GeoServerLoaderProxy(GeoServerResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.loader = this.lookupGeoServerLoader(applicationContext);
        this.loader.setApplicationContext(applicationContext);
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (this.loader != null) {
            return this.loader.postProcessAfterInitialization(bean, beanName);
        }
        return bean;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (this.loader != null) {
            return this.loader.postProcessBeforeInitialization(bean, beanName);
        }
        return bean;
    }

    public void reload() throws Exception {
        if (this.loader != null) {
            this.loader.reload();
        }
    }

    public void onApplicationEvent(ContextClosedEvent event) {
        if (this.loader != null) {
            this.loader.destroy();
        }
    }

    protected GeoServerLoader lookupGeoServerLoader(ApplicationContext appContext) {
        GeoServerLoader loader = (GeoServerLoader)GeoServerExtensions.bean(GeoServerLoader.class, (ApplicationContext)appContext);
        if (loader == null) {
            loader = this.createDefaultLoader(appContext);
        }
        return loader;
    }

    @Override
    public void initialize(GeoServer geoServer) throws Exception {
        this.loader.initializeDefaultStyles(geoServer.getCatalog());
    }

    protected GeoServerLoader createDefaultLoader(ApplicationContext appContext) {
        if (DataDirectoryGeoServerLoader.isEnabled(appContext)) {
            GeoServerDataDirectory dataDirectory = this.getBean(GeoServerDataDirectory.class);
            GeoServerSecurityManager securityManager = this.getBean(GeoServerSecurityManager.class);
            GeoServerConfigurationLock configLock = this.getBean(GeoServerConfigurationLock.class);
            return new DataDirectoryGeoServerLoader(dataDirectory, securityManager, configLock);
        }
        return new DefaultGeoServerLoader(this.resourceLoader);
    }

    protected <T> T getBean(Class<T> type) {
        return (T)Objects.requireNonNull(GeoServerExtensions.bean(type));
    }
}

