/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.CatalogVisitor;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.Predicates;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.catalog.WMTSLayerInfo;
import org.geoserver.catalog.WMTSStoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.LayerGroupStyle;
import org.geoserver.catalog.util.CloseableIterator;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.MultiValuedFilter;
import org.geotools.util.logging.Logging;

public class CascadeDeleteVisitor
implements CatalogVisitor {
    static final Logger LOGGER = Logging.getLogger(CascadeDeleteVisitor.class);
    Catalog catalog;

    public CascadeDeleteVisitor(Catalog catalog) {
        this.catalog = catalog;
    }

    @Override
    public void visit(Catalog catalog) {
    }

    @Override
    public void visit(WorkspaceInfo workspace) {
        for (LayerGroupInfo group : this.catalog.getLayerGroupsByWorkspace(workspace)) {
            group.accept(this);
        }
        for (StoreInfo s : this.catalog.getStoresByWorkspace(workspace, StoreInfo.class)) {
            s.accept(this);
        }
        NamespaceInfo ns = this.catalog.getNamespaceByPrefix(workspace.getName());
        if (ns != null) {
            ns.accept(this);
        }
        for (StyleInfo style : this.catalog.getStylesByWorkspace(workspace)) {
            style.accept(this);
        }
        this.catalog.remove(workspace);
    }

    @Override
    public void visit(NamespaceInfo namespace) {
        this.catalog.remove(namespace);
    }

    void visitStore(StoreInfo store) {
        List<ResourceInfo> resources = this.catalog.getResourcesByStore(store, ResourceInfo.class);
        for (ResourceInfo ri : resources) {
            List<LayerInfo> layers = this.catalog.getLayers(ri);
            if (!layers.isEmpty()) {
                for (LayerInfo li : layers) {
                    li.accept(this);
                }
                continue;
            }
            ri.accept(this);
        }
        this.catalog.remove(store);
    }

    @Override
    public void visit(DataStoreInfo dataStore) {
        this.visitStore(dataStore);
    }

    @Override
    public void visit(CoverageStoreInfo coverageStore) {
        this.visitStore(coverageStore);
    }

    @Override
    public void visit(WMSStoreInfo wmsStore) {
        this.visitStore(wmsStore);
    }

    @Override
    public void visit(WMTSStoreInfo store) {
        this.visitStore(store);
    }

    @Override
    public void visit(FeatureTypeInfo featureType) {
        this.catalog.remove(featureType);
    }

    @Override
    public void visit(CoverageInfo coverage) {
        this.catalog.remove(coverage);
    }

    @Override
    public void visit(LayerInfo layer) {
        Filter groupContainsLayer = Predicates.equal("layers.id", layer.getId(), MultiValuedFilter.MatchAction.ANY);
        Filter groupStyleContainsLayer = Predicates.contains("layerGroupStyle.layers.id", layer.getId());
        Filter orFilter = Predicates.or(groupContainsLayer, groupStyleContainsLayer);
        try (CloseableIterator<LayerGroupInfo> groups = this.catalog.list(LayerGroupInfo.class, orFilter);){
            while (groups.hasNext()) {
                LayerGroupInfo group = (LayerGroupInfo)groups.next();
                int index = group.getLayers().indexOf(layer);
                while (index != -1) {
                    group.getLayers().remove(index);
                    group.getStyles().remove(index);
                    index = group.getLayers().indexOf(layer);
                }
                if (group.getLayers().isEmpty()) {
                    this.visit(this.catalog.getLayerGroup(group.getId()));
                    continue;
                }
                this.handleGroupStyleLayers(group, layer);
                this.catalog.save(group);
            }
        }
        ResourceInfo resource = layer.getResource();
        this.catalog.remove(layer);
        this.catalog.remove(resource);
    }

    private void handleGroupStyleGroups(LayerGroupInfo group, LayerGroupInfo lgRemove) {
        List<LayerGroupStyle> groupStyles = group.getLayerGroupStyles();
        ArrayList<LayerGroupStyle> toRemove = new ArrayList<LayerGroupStyle>();
        for (LayerGroupStyle gs : groupStyles) {
            int index = this.getLayerGroupIndex(lgRemove, gs.getLayers());
            while (index != -1) {
                group.getLayers().remove(index);
                group.getStyles().remove(index);
                index = this.getLayerGroupIndex(lgRemove, gs.getLayers());
            }
            if (!gs.getLayers().isEmpty()) continue;
            toRemove.add(gs);
        }
        group.getLayerGroupStyles().removeAll(toRemove);
    }

    private void handleGroupStyleLayers(LayerGroupInfo group, LayerInfo layer) {
        List<LayerGroupStyle> groupStyles = group.getLayerGroupStyles();
        ArrayList<String> toRemove = new ArrayList<String>();
        for (LayerGroupStyle gs : groupStyles) {
            int index = gs.getLayers().indexOf(layer);
            while (index != -1) {
                gs.getLayers().remove(index);
                gs.getStyles().remove(index);
                index = gs.getLayers().indexOf(layer);
            }
            if (!gs.getLayers().isEmpty()) continue;
            toRemove.add(gs.getId());
        }
        List<LayerGroupStyle> groupStyleList = group.getLayerGroupStyles().stream().filter(lgs -> !toRemove.contains(lgs.getId())).collect(Collectors.toList());
        group.setLayerGroupStyles(groupStyleList);
    }

    private StyleInfo getResourceDefaultStyle(ResourceInfo resource, StyleInfo removedStyle) {
        StyleInfo style = null;
        try {
            style = new CatalogBuilder(this.catalog).getDefaultStyle(resource);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Could not find default style for resource " + resource + ", using Point style", e);
        }
        if (style == null || style.equals(removedStyle)) {
            return this.catalog.getStyleByName("point");
        }
        return style;
    }

    private void removeStyleInLayer(LayerInfo layer, StyleInfo style) {
        StyleInfo ds;
        boolean dirty = false;
        if (layer.getStyles().remove(style)) {
            dirty = true;
        }
        if ((ds = layer.getDefaultStyle()) != null && ds.equals(style)) {
            StyleInfo newDefaultStyle;
            dirty = true;
            if (!layer.getStyles().isEmpty()) {
                newDefaultStyle = layer.getStyles().iterator().next();
                layer.getStyles().remove(newDefaultStyle);
            } else {
                newDefaultStyle = this.getResourceDefaultStyle(layer.getResource(), style);
            }
            layer.setDefaultStyle(newDefaultStyle);
        }
        if (dirty) {
            this.catalog.save(layer);
        }
    }

    private void removeStyleInLayerGroup(LayerGroupInfo group, StyleInfo style) {
        boolean dirty = false;
        if (style.equals(group.getRootLayerStyle())) {
            group.setRootLayerStyle(this.getResourceDefaultStyle(group.getRootLayer().getResource(), style));
            dirty = true;
        }
        List<StyleInfo> styles = group.getStyles();
        for (int i = 0; i < styles.size(); ++i) {
            StyleInfo publishedStyle = styles.get(i);
            if (publishedStyle == null || !publishedStyle.equals(style)) continue;
            LayerInfo layer = (LayerInfo)group.getLayers().get(i);
            if (!layer.getDefaultStyle().equals(style)) {
                styles.set(i, layer.getDefaultStyle());
            } else {
                styles.set(i, this.getResourceDefaultStyle(layer.getResource(), style));
            }
            dirty = true;
        }
        boolean groupStyleResult = this.removeStyleInGroupStyle(style, group);
        if (!dirty) {
            dirty = groupStyleResult;
        }
        if (dirty) {
            this.catalog.save(group);
        }
    }

    private boolean removeStyleInGroupStyle(StyleInfo style, LayerGroupInfo group) {
        boolean dirty = false;
        List<LayerGroupStyle> groupStyles = group.getLayerGroupStyles();
        for (LayerGroupStyle groupStyle : groupStyles) {
            List<StyleInfo> styles = groupStyle.getStyles();
            int index = styles.indexOf(style);
            if (index != -1) {
                dirty = true;
            }
            while (index != -1) {
                LayerInfo layer = (LayerInfo)group.getLayers().get(index);
                if (!layer.getDefaultStyle().equals(style)) {
                    styles.set(index, layer.getDefaultStyle());
                } else {
                    styles.set(index, this.getResourceDefaultStyle(layer.getResource(), style));
                }
                index = styles.indexOf(style);
            }
        }
        return dirty;
    }

    @Override
    public void visit(StyleInfo style) {
        Filter anyStyle = Predicates.equal("styles.id", style.getId(), MultiValuedFilter.MatchAction.ANY);
        Filter layersAssociated = Predicates.or(Predicates.equal("defaultStyle.id", style.getId()), anyStyle);
        try (CloseableIterator<LayerInfo> it = this.catalog.list(LayerInfo.class, layersAssociated);){
            while (it.hasNext()) {
                LayerInfo layer = (LayerInfo)it.next();
                this.removeStyleInLayer(layer, style);
            }
        }
        Filter groupAssociated = Predicates.or(Predicates.equal("rootLayerStyle.id", style.getId()), anyStyle);
        Filter groupStylesAssociated = Predicates.contains("layerGroupStyles.styles.id", style.getId());
        Filter allAssociated = Predicates.or(groupAssociated, groupStylesAssociated);
        try (CloseableIterator<LayerGroupInfo> it = this.catalog.list(LayerGroupInfo.class, allAssociated);){
            while (it.hasNext()) {
                LayerGroupInfo group = (LayerGroupInfo)it.next();
                this.removeStyleInLayerGroup(group, style);
            }
        }
        this.catalog.remove(style);
    }

    @Override
    public void visit(LayerGroupInfo layerGroupToRemove) {
        Filter associatedTo = Predicates.equal("layers.id", layerGroupToRemove.getId(), MultiValuedFilter.MatchAction.ANY);
        Filter stylesAssociated = Predicates.equal("layerGroupStyles.layers.id", layerGroupToRemove.getId());
        Filter or = Predicates.or(associatedTo, stylesAssociated);
        try (CloseableIterator<LayerGroupInfo> it = this.catalog.list(LayerGroupInfo.class, or);){
            while (it.hasNext()) {
                LayerGroupInfo group = (LayerGroupInfo)it.next();
                int index = this.getLayerGroupIndex(layerGroupToRemove, group.getLayers());
                while (index != -1) {
                    group.getLayers().remove(index);
                    group.getStyles().remove(index);
                    index = this.getLayerGroupIndex(layerGroupToRemove, group.getLayers());
                }
                if (group.getLayers().isEmpty()) {
                    this.visit(group);
                    continue;
                }
                this.handleGroupStyleGroups(group, layerGroupToRemove);
                this.catalog.save(group);
            }
        }
        this.catalog.remove(layerGroupToRemove);
    }

    private int getLayerGroupIndex(LayerGroupInfo layerGroup, List<PublishedInfo> publishables) {
        int idx = 0;
        String id = layerGroup.getId();
        for (PublishedInfo pi : publishables) {
            if (pi instanceof LayerGroupInfo && id.equals(pi.getId())) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    @Override
    public void visit(WMSLayerInfo wmsLayer) {
        this.catalog.remove(wmsLayer);
    }

    @Override
    public void visit(WMTSLayerInfo wmtsLayer) {
        this.catalog.remove(wmtsLayer);
    }
}

