/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import org.geoserver.ows.kvp.TimeParser;
import org.geotools.util.DateRange;
import org.geotools.util.Range;

public class AcceptableRange {
    private Number before;
    private Number after;
    private Class<?> dataType;

    public static AcceptableRange getAcceptableRange(String spec, Class<?> dataType) throws ParseException {
        Number before;
        if (spec == null || spec.trim().isEmpty()) {
            return null;
        }
        String[] split = spec.split("/");
        if (split.length > 2) {
            throw new IllegalArgumentException("Invalid acceptable range specification, must be either a single value, or two values split by a forward slash");
        }
        Number after = before = AcceptableRange.parseValue(split[0], dataType);
        if (split.length == 2) {
            after = AcceptableRange.parseValue(split[1], dataType);
        }
        if (before.doubleValue() == 0.0 && after.doubleValue() == 0.0) {
            return null;
        }
        return new AcceptableRange(before, after, dataType);
    }

    private static Number parseValue(String s, Class<?> dataType) throws ParseException {
        if (Date.class.isAssignableFrom(dataType)) {
            return TimeParser.parsePeriod((String)s);
        }
        throw new IllegalArgumentException("Unsupported value type " + dataType);
    }

    public AcceptableRange(Number before, Number after, Class<?> dataType) {
        this.before = before;
        this.after = after;
        this.dataType = dataType;
    }

    public Range getSearchRange(Object value) {
        if (value instanceof Range) {
            Range range = (Range)value;
            Range before = this.getSearchRangeOnSingleValue(range.getMinValue());
            Range after = this.getSearchRangeOnSingleValue(range.getMaxValue());
            return before.union(after);
        }
        return this.getSearchRangeOnSingleValue(value);
    }

    public Range getSearchRangeOnSingleValue(Object value) {
        if (Date.class.isAssignableFrom(this.dataType)) {
            Date center = (Date)value;
            Calendar cal = Calendar.getInstance();
            cal.setTime(center);
            cal.setTimeInMillis(cal.getTimeInMillis() - this.before.longValue());
            Date min = cal.getTime();
            cal.setTime(center);
            cal.setTimeInMillis(cal.getTimeInMillis() + this.after.longValue());
            Date max = cal.getTime();
            return new DateRange(min, max);
        }
        throw new IllegalArgumentException("Unsupported value type " + this.dataType);
    }

    public Number getBefore() {
        return this.before;
    }

    public Number getAfter() {
        return this.after;
    }

    public Class<?> getDataType() {
        return this.dataType;
    }
}

