/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.system.status;

import java.util.List;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.system.status.BaseSystemInfoCollector;
import org.geoserver.system.status.MetricValue;
import org.geoserver.system.status.Metrics;
import org.geoserver.system.status.OSHISystemInfoMonitor;
import org.geoserver.system.status.SystemInfoCollector;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.hamcrest.CoreMatchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ErrorCollector;

public class SystemInfoCollectorTest
extends GeoServerSystemTestSupport {
    @Rule
    public ErrorCollector collector = new ErrorCollector();

    @Test
    public void testMetricCollector() {
        SystemInfoCollector systemInfoCollector = (SystemInfoCollector)GeoServerExtensions.bean(SystemInfoCollector.class);
        Metrics collected = systemInfoCollector.retrieveAllSystemInfo();
        List metrics = collected.getMetrics();
        for (MetricValue m : metrics) {
            this.collector.checkThat("Metric for " + m.getName() + " available but value is not retrieved", (Object)(m.getAvailable() != false && !m.getValue().equals(BaseSystemInfoCollector.DEFAULT_VALUE) || m.getAvailable() == false && m.getValue().equals(BaseSystemInfoCollector.DEFAULT_VALUE) ? 1 : 0), CoreMatchers.equalTo((Object)true));
        }
    }

    @Test
    public void testStatisticsEnabled() throws InterruptedException {
        SystemInfoCollector systemInfoCollector = (SystemInfoCollector)GeoServerExtensions.bean(SystemInfoCollector.class);
        systemInfoCollector.setStatisticsStatus(Boolean.valueOf(true));
        Thread.sleep(3000L);
        Metrics collected = systemInfoCollector.retrieveAllSystemInfo();
        List metrics = collected.getMetrics();
        Assert.assertNotEquals((Object)BaseSystemInfoCollector.DEFAULT_VALUE, (Object)((MetricValue)metrics.get(0)).getValue());
    }

    @Test
    public void testStatisticsDisabled() {
        OSHISystemInfoMonitor systemInfoCollector = (OSHISystemInfoMonitor)GeoServerExtensions.bean(OSHISystemInfoMonitor.class);
        systemInfoCollector.setStatisticsStatus(Boolean.valueOf(false));
        Metrics collected = systemInfoCollector.retrieveAllSystemInfo();
        List metrics = collected.getMetrics();
        for (MetricValue m : metrics) {
            Assert.assertEquals((Object)BaseSystemInfoCollector.DEFAULT_VALUE, (Object)m.getValue());
        }
        Assert.assertFalse((boolean)systemInfoCollector.isRunning());
    }

    @Override
    protected void destroyGeoServer() {
        OSHISystemInfoMonitor systemInfoCollector = (OSHISystemInfoMonitor)GeoServerExtensions.bean(OSHISystemInfoMonitor.class);
        super.destroyGeoServer();
        Assert.assertFalse((boolean)systemInfoCollector.isRunning());
    }
}

