/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.TreeMap;
import org.geoserver.security.impl.AbstractUserGroupStore;
import org.geoserver.security.impl.GeoServerUserGroup;
import org.geoserver.security.impl.MemoryGeoserverUserGroup;
import org.geoserver.security.impl.MemoryUserGroupService;

public class MemoryUserGroupStore
extends AbstractUserGroupStore {
    protected void serialize() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectOutputStream oout = new ObjectOutputStream(out);
        oout.writeObject(this.helper.userMap);
        oout.writeObject(this.helper.groupMap);
        oout.writeObject(this.helper.user_groupMap);
        oout.writeObject(this.helper.group_userMap);
        oout.writeObject(this.helper.propertyMap);
        ((MemoryUserGroupService)this.service).byteArray = out.toByteArray();
        oout.close();
    }

    protected void deserialize() throws IOException {
        this.clearMaps();
        byte[] bytes = ((MemoryUserGroupService)this.service).byteArray;
        if (bytes == null) {
            this.setModified(false);
            return;
        }
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        ObjectInputStream oin = new ObjectInputStream(in);
        try {
            this.helper.userMap = (TreeMap)oin.readObject();
            this.helper.groupMap = (TreeMap)oin.readObject();
            this.helper.user_groupMap = (TreeMap)oin.readObject();
            this.helper.group_userMap = (TreeMap)oin.readObject();
            this.helper.propertyMap = (TreeMap)oin.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
        this.setModified(false);
    }

    public GeoServerUserGroup createGroupObject(String groupname, boolean isEnabled) throws IOException {
        MemoryGeoserverUserGroup group = new MemoryGeoserverUserGroup(groupname);
        group.setEnabled(isEnabled);
        return group;
    }
}

