/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.TreeMap;
import org.geoserver.security.impl.AbstractRoleStore;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.impl.MemoryGeoserverRole;
import org.geoserver.security.impl.MemoryRoleService;

public class MemoryRoleStore
extends AbstractRoleStore {
    protected void serialize() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectOutputStream oout = new ObjectOutputStream(out);
        oout.writeObject(this.helper.roleMap);
        oout.writeObject(this.helper.role_parentMap);
        oout.writeObject(this.helper.user_roleMap);
        oout.writeObject(this.helper.group_roleMap);
        ((MemoryRoleService)this.service).byteArray = out.toByteArray();
        oout.close();
    }

    protected void deserialize() throws IOException {
        this.clearMaps();
        byte[] bytes = ((MemoryRoleService)this.service).byteArray;
        if (bytes == null) {
            this.setModified(false);
            return;
        }
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        ObjectInputStream oin = new ObjectInputStream(in);
        try {
            this.helper.roleMap = (TreeMap)oin.readObject();
            this.helper.role_parentMap = (HashMap)oin.readObject();
            this.helper.user_roleMap = (TreeMap)oin.readObject();
            this.helper.group_roleMap = (TreeMap)oin.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
        this.setModified(false);
    }

    public GeoServerRole createRoleObject(String role) throws IOException {
        return new MemoryGeoserverRole(role);
    }
}

