/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import java.io.File;
import java.io.IOException;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.resource.Resource;
import org.geoserver.security.impl.AbstractFileAccessTest;
import org.geoserver.security.impl.DefaultFileAccessManager;
import org.geoserver.security.impl.FileSandboxEnforcer;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.context.ApplicationContext;

public abstract class AbstractSandboxEnforcerTest
extends AbstractFileAccessTest {
    protected static final String ADMIN_STORE = "lakesAdmin";
    protected static final String CITE_STORE = "lakesCite";
    protected static final String CGF_STORE = "lakesCgf";
    protected static final String CDF_STORE = "lakesCdf";

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        GeoServerExtensions.bean(FileSandboxEnforcer.class, (ApplicationContext)applicationContext);
    }

    @After
    public void clearFileAccessManagerConfiguration() {
        System.clearProperty(DefaultFileAccessManager.GEOSERVER_DATA_SANDBOX);
        Resource layerSecurity = this.getDataDirectory().get(new String[]{"security/layers.properties"});
        layerSecurity.delete();
        this.fileAccessManager.reload();
    }

    @Before
    public void clearStores() throws Exception {
        Catalog catalog = this.getCatalog();
        for (StoreInfo ds : catalog.getStores(StoreInfo.class)) {
            String name = ds.getName();
            if (!ADMIN_STORE.equals(name) && !CITE_STORE.equals(name)) continue;
            catalog.remove(ds);
        }
    }

    @Test
    public void testNoRestrictions() throws Exception {
        File testDirectory = new File("./target/test").getCanonicalFile();
        this.loginAdmin();
        this.addStore(ADMIN_STORE, testDirectory);
        this.loginCite();
        this.addStore(CITE_STORE, testDirectory);
    }

    @Test
    public void testSystemSandbox() throws Exception {
        File systemSandbox = new File("./target/systemSandbox").getCanonicalFile();
        systemSandbox.mkdirs();
        System.setProperty(DefaultFileAccessManager.GEOSERVER_DATA_SANDBOX, systemSandbox.getAbsolutePath());
        this.fileAccessManager.reload();
        File testDirectory = new File("./target/test").getCanonicalFile();
        this.loginAdmin();
        Catalog catalog = this.getCatalog();
        FileSandboxEnforcer.SandboxException se = (FileSandboxEnforcer.SandboxException)Assert.assertThrows(FileSandboxEnforcer.SandboxException.class, () -> this.addStore(ADMIN_STORE, testDirectory));
        MatcherAssert.assertThat((Object)se.getMessage(), (Matcher)Matchers.allOf((Matcher)Matchers.startsWith((String)"Access to "), (Matcher)Matchers.containsString((String)testDirectory.getAbsolutePath()), (Matcher)Matchers.endsWith((String)" denied by file sandboxing")));
        Assert.assertNull((Object)catalog.getDataStoreByName(ADMIN_STORE));
    }

    @Test
    public void testWorkspaceAdminSandbox() throws Exception {
        this.configureCiteAccess();
        this.fileAccessManager.reload();
        this.loginCite();
        this.addStore(CITE_STORE, this.citeFolder);
        Assert.assertThrows(FileSandboxEnforcer.SandboxException.class, () -> this.addStore(CGF_STORE, this.cgfFolder));
        Assert.assertThrows(FileSandboxEnforcer.SandboxException.class, () -> this.addStore(CDF_STORE, this.cdfFolder));
        Assert.assertThrows(FileSandboxEnforcer.SandboxException.class, () -> this.modifyStore(CITE_STORE, this.cgfFolder));
        StoreInfo citeStore = this.getCatalog().getStoreByName(CITE_STORE, StoreInfo.class);
        this.testLocation(citeStore, this.citeFolder);
    }

    @Test
    public void testMultipleWorkspaceAdminSandbox() throws Exception {
        this.configureCiteCgfMissingAccess();
        this.loginCiteCgfMissing();
        this.addStore(CITE_STORE, this.citeFolder);
        this.addStore(CGF_STORE, this.cgfFolder);
        Assert.assertThrows(FileSandboxEnforcer.SandboxException.class, () -> this.addStore(CDF_STORE, this.cdfFolder));
    }

    protected abstract void testLocation(StoreInfo var1, File var2) throws Exception;

    protected abstract void addStore(String var1, File var2) throws IOException;

    protected abstract void modifyStore(String var1, File var2);
}

