/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import java.io.IOException;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.security.AbstractSecurityServiceTest;
import org.geoserver.security.GeoServerRoleService;
import org.geoserver.security.GeoServerRoleStore;
import org.geoserver.security.impl.GeoServerRole;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractRoleServiceTest
extends AbstractSecurityServiceTest {
    protected GeoServerRoleService service;
    protected GeoServerRoleStore store;

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        this.service = this.createRoleService("test");
    }

    @Before
    public void init() throws IOException {
        this.service = this.getSecurityManager().loadRoleService("test");
        this.store = this.createStore(this.service);
    }

    @Test
    public void testIsModified() throws Exception {
        Assert.assertFalse((boolean)this.store.isModified());
        this.insertValues(this.store);
        Assert.assertTrue((boolean)this.store.isModified());
        this.store.load();
        Assert.assertFalse((boolean)this.store.isModified());
        this.insertValues(this.store);
        this.store.store();
        Assert.assertFalse((boolean)this.store.isModified());
        GeoServerRole role = this.store.createRoleObject("ROLE_DUMMY");
        GeoServerRole role_parent = this.store.createRoleObject("ROLE_PARENT");
        Assert.assertFalse((boolean)this.store.isModified());
        this.store.addRole(role);
        this.store.addRole(role_parent);
        Assert.assertTrue((boolean)this.store.isModified());
        this.store.store();
        Assert.assertFalse((boolean)this.store.isModified());
        this.store.updateRole(role);
        Assert.assertTrue((boolean)this.store.isModified());
        this.store.load();
        Assert.assertFalse((boolean)this.store.isModified());
        this.store.removeRole(role);
        Assert.assertTrue((boolean)this.store.isModified());
        this.store.load();
        Assert.assertFalse((boolean)this.store.isModified());
        this.store.associateRoleToGroup(role, "agroup");
        Assert.assertTrue((boolean)this.store.isModified());
        this.store.store();
        Assert.assertFalse((boolean)this.store.isModified());
        this.store.disAssociateRoleFromGroup(role, "agroup");
        Assert.assertTrue((boolean)this.store.isModified());
        this.store.load();
        Assert.assertFalse((boolean)this.store.isModified());
        this.store.associateRoleToUser(role, "auser");
        Assert.assertTrue((boolean)this.store.isModified());
        this.store.store();
        Assert.assertFalse((boolean)this.store.isModified());
        this.store.disAssociateRoleFromUser(role, "auser");
        Assert.assertTrue((boolean)this.store.isModified());
        this.store.load();
        Assert.assertFalse((boolean)this.store.isModified());
        this.store.setParentRole(role, role_parent);
        Assert.assertTrue((boolean)this.store.isModified());
        this.store.store();
        Assert.assertFalse((boolean)this.store.isModified());
        this.store.setParentRole(role, null);
        Assert.assertTrue((boolean)this.store.isModified());
        this.store.store();
        Assert.assertFalse((boolean)this.store.isModified());
        this.store.clear();
        Assert.assertTrue((boolean)this.store.isModified());
        this.store.load();
    }

    @Test
    public void testInsert() throws Exception {
        this.checkEmpty(this.service);
        this.checkEmpty((GeoServerRoleService)this.store);
        this.insertValues(this.store);
        if (!this.isJDBCTest()) {
            this.checkEmpty(this.service);
        }
        this.checkValuesInserted((GeoServerRoleService)this.store);
        this.store.load();
        this.checkEmpty((GeoServerRoleService)this.store);
        this.checkEmpty(this.service);
        this.insertValues(this.store);
        this.store.store();
        this.checkValuesInserted((GeoServerRoleService)this.store);
        this.checkValuesInserted(this.service);
    }

    @Test
    public void testModify() throws Exception {
        this.checkEmpty(this.service);
        this.checkEmpty((GeoServerRoleService)this.store);
        this.insertValues(this.store);
        this.store.store();
        this.checkValuesInserted((GeoServerRoleService)this.store);
        this.checkValuesInserted(this.service);
        this.modifyValues(this.store);
        if (!this.isJDBCTest()) {
            this.checkValuesInserted(this.service);
        }
        this.checkValuesModified((GeoServerRoleService)this.store);
        this.store.load();
        this.checkValuesInserted((GeoServerRoleService)this.store);
        this.checkValuesInserted(this.service);
        this.modifyValues(this.store);
        this.store.store();
        this.checkValuesModified((GeoServerRoleService)this.store);
        this.checkValuesModified(this.service);
    }

    @Test
    public void testRemove() throws Exception {
        this.checkEmpty(this.service);
        this.checkEmpty((GeoServerRoleService)this.store);
        this.insertValues(this.store);
        this.store.store();
        this.checkValuesInserted((GeoServerRoleService)this.store);
        this.checkValuesInserted(this.service);
        this.removeValues(this.store);
        if (!this.isJDBCTest()) {
            this.checkValuesInserted(this.service);
        }
        this.checkValuesRemoved((GeoServerRoleService)this.store);
        this.store.load();
        this.checkValuesInserted((GeoServerRoleService)this.store);
        this.checkValuesInserted(this.service);
        this.removeValues(this.store);
        this.store.store();
        this.checkValuesRemoved((GeoServerRoleService)this.store);
        this.checkValuesRemoved(this.service);
    }
}

