/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.csp.predicate;

import java.util.regex.PatternSyntaxException;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.security.csp.CSPConfiguration;
import org.geoserver.security.csp.CSPHttpRequestWrapper;
import org.geoserver.security.csp.predicate.CSPPredicateProperty;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;

public class CSPPredicatePropertyTest {
    private static final String KEY = "geoserver.csp.frameAncestors";
    private MockHttpServletRequest request = null;
    private CSPHttpRequestWrapper wrapper = null;
    private CSPConfiguration config = null;

    @Before
    public void setUp() {
        this.request = new MockHttpServletRequest();
        this.config = new CSPConfiguration();
        this.wrapper = new CSPHttpRequestWrapper((HttpServletRequest)this.request, this.config);
    }

    @After
    public void resetProperty() {
        System.clearProperty(KEY);
    }

    @Test
    public void testConstructorPropertyNotAllowed() {
        String name = "java.version";
        Exception e = (Exception)Assert.assertThrows(IllegalArgumentException.class, () -> new CSPPredicateProperty(name, "^$"));
        Assert.assertEquals((Object)("Property key not allowed: " + name), (Object)e.getMessage());
    }

    @Test
    public void testConstructorInvalidRegex() {
        Assert.assertThrows(PatternSyntaxException.class, () -> new CSPPredicateProperty(KEY, "["));
    }

    @Test
    public void testPredicatePropertySetMatches() {
        System.setProperty(KEY, "true");
        Assert.assertTrue((boolean)new CSPPredicateProperty(KEY, "^true$").test(null));
    }

    @Test
    public void testPredicatePropertySetNotMatches() {
        System.setProperty(KEY, "false");
        Assert.assertFalse((boolean)new CSPPredicateProperty(KEY, "^true$").test(null));
    }

    @Test
    public void testPredicateFieldSetMatches() {
        System.clearProperty(KEY);
        this.config.setFrameAncestors("true");
        Assert.assertTrue((boolean)new CSPPredicateProperty(KEY, "^true$").test(this.wrapper));
    }

    @Test
    public void testPredicateFieldSetNotMatches() {
        System.clearProperty(KEY);
        this.config.setFrameAncestors("false");
        Assert.assertFalse((boolean)new CSPPredicateProperty(KEY, "^true$").test(this.wrapper));
    }

    @Test
    public void testPredicatePropertyAndFieldUnsetMatches() {
        System.clearProperty(KEY);
        Assert.assertTrue((boolean)new CSPPredicateProperty(KEY, "^$").test(this.wrapper));
    }

    @Test
    public void testPredicatePropertyAndFieldUnsetNotMatches() {
        System.clearProperty(KEY);
        Assert.assertFalse((boolean)new CSPPredicateProperty(KEY, "^true$").test(this.wrapper));
    }
}

