/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.auth;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import org.geoserver.security.auth.AuthenticationCache;
import org.springframework.security.core.Authentication;

public class TestingAuthenticationCache
implements AuthenticationCache {
    Map<String, Map<String, byte[]>> cache = new HashMap<String, Map<String, byte[]>>();
    public static Integer DEFAULT_IDLE_SECS = 60;
    public static Integer DEFAULT_LIVE_SECS = 600;
    Map<String, Map<String, Integer[]>> expireMap = new HashMap<String, Map<String, Integer[]>>();

    public void removeAll() {
        this.cache.clear();
        this.expireMap.clear();
    }

    public void removeAll(String filterName) {
        this.cache.remove(filterName);
        this.expireMap.remove(filterName);
    }

    public void remove(String filterName, String cacheKey) {
        Map<String, Integer[]> map2;
        Map<String, byte[]> map = this.cache.get(filterName);
        if (map != null) {
            map.remove(cacheKey);
        }
        if ((map2 = this.expireMap.get(filterName)) != null) {
            map.remove(cacheKey);
        }
    }

    public Authentication get(String filterName, String cacheKey) {
        Map<String, byte[]> map = this.cache.get(filterName);
        if (map != null) {
            return this.deserializeAuthentication(map.get(cacheKey));
        }
        return null;
    }

    public Integer[] getExpireTimes(String filterName, String cacheKey) {
        Integer[] result = null;
        Map<String, Integer[]> map = this.expireMap.get(filterName);
        if (map != null) {
            result = map.get(cacheKey);
        }
        if (result == null) {
            return new Integer[]{DEFAULT_IDLE_SECS, DEFAULT_LIVE_SECS};
        }
        return result;
    }

    public void put(String filterName, String cacheKey, Authentication auth, Integer timeToIdleSeconds, Integer timeToLiveSeconds) {
        this.put(filterName, cacheKey, auth);
        if (timeToIdleSeconds != null || timeToLiveSeconds != null) {
            Map<String, Integer[]> map = this.expireMap.get(filterName);
            if (map == null) {
                map = new HashMap<String, Integer[]>();
                this.expireMap.put(filterName, map);
            }
            map.put(cacheKey, new Integer[]{timeToIdleSeconds, timeToLiveSeconds});
        }
    }

    public void put(String filterName, String cacheKey, Authentication auth) {
        Map<String, byte[]> map = this.cache.get(filterName);
        if (map == null) {
            map = new HashMap<String, byte[]>();
            this.cache.put(filterName, map);
        }
        map.put(cacheKey, this.serializeAuthentication(auth));
    }

    Authentication deserializeAuthentication(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        try {
            ByteArrayInputStream bin = new ByteArrayInputStream(bytes);
            ObjectInputStream in = new ObjectInputStream(bin);
            Authentication auth = (Authentication)in.readObject();
            in.close();
            return auth;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public byte[] serializeAuthentication(Authentication auth) {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bout);
            out.writeObject(auth);
            out.close();
            return bout.toByteArray();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void onReset() {
        this.removeAll();
    }
}

