/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.HTTPHeadersCollector;
import org.geoserver.ows.Request;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.CaseInsensitiveMap;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.GeoServerEnvironment;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.geoserver.test.SystemTest;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SystemTest.class})
public class URLManglersTest
extends GeoServerSystemTestSupport {
    private static final String BASEURL = "http://localhost:8080/geoserver";

    @BeforeClass
    public static void init() {
        System.setProperty("ALLOW_ENV_PARAMETRIZATION", "true");
        GeoServerEnvironment.reloadAllowEnvParametrization();
    }

    @AfterClass
    public static void finalizing() {
        System.setProperty("ALLOW_ENV_PARAMETRIZATION", "false");
        GeoServerEnvironment.reloadAllowEnvParametrization();
    }

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        FileUtils.copyFileToDirectory((File)new File("./src/test/resources/geoserver-environment.properties"), (File)testData.getDataDirectoryRoot());
    }

    @Before
    public void setup() {
        Dispatcher.REQUEST.remove();
        GeoServerInfo gi = this.getGeoServer().getGlobal();
        gi.getSettings().setProxyBaseUrl(null);
        this.getGeoServer().save(gi);
    }

    @Test
    public void testBasic() {
        String url = ResponseUtils.buildURL((String)BASEURL, (String)"test", null, (URLMangler.URLType)URLMangler.URLType.SERVICE);
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/test", (Object)url);
    }

    @Test
    public void testKVP() {
        String url = ResponseUtils.buildURL((String)BASEURL, (String)"test", Collections.singletonMap("param", "value()"), (URLMangler.URLType)URLMangler.URLType.SERVICE);
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/test?param=value%28%29", (Object)url);
    }

    @Test
    public void testUpdateRawKVP() {
        Request wrappedRequest = new Request();
        wrappedRequest.setRawKvp(Collections.singletonMap("Language", "value"));
        Dispatcher.REQUEST.set(wrappedRequest);
        String url = ResponseUtils.buildURL((String)BASEURL, (String)"test", new HashMap(), (URLMangler.URLType)URLMangler.URLType.SERVICE);
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/test?Language=value", (Object)url);
    }

    @Test
    public void testProxyBase() {
        GeoServerInfo gi = this.getGeoServer().getGlobal();
        gi.getSettings().setProxyBaseUrl("http://geoserver.org/");
        this.getGeoServer().save(gi);
        String url = ResponseUtils.buildURL((String)BASEURL, (String)"test", null, (URLMangler.URLType)URLMangler.URLType.SERVICE);
        Assert.assertEquals((Object)"http://geoserver.org/test", (Object)url);
    }

    @Test
    public void testProxyBaseParametrized() {
        GeoServerInfo gi = this.getGeoServer().getGlobal();
        gi.getSettings().setProxyBaseUrl("${proxy.custom}");
        this.getGeoServer().save(gi);
        String url = ResponseUtils.buildURL((String)BASEURL, (String)"test", null, (URLMangler.URLType)URLMangler.URLType.SERVICE);
        Assert.assertEquals((Object)"http://custom.host/test", (Object)url);
        gi.getSettings().setProxyBaseUrl("${X-Forwarded-Proto}://${X-Forwarded-Host}/${proxy.custom}");
        this.getGeoServer().save(gi);
        url = ResponseUtils.buildURL((String)BASEURL, (String)"test", null, (URLMangler.URLType)URLMangler.URLType.SERVICE);
        Assert.assertEquals((Object)"${X-Forwarded-Proto}://${X-Forwarded-Host}/http://custom.host/test", (Object)url);
    }

    @Test
    public void testProxyBaseUrlSystemProperty() {
        System.setProperty("PROXY_BASE_URL", "${X-Forwarded-Proto}://${X-Forwarded-Host}/${proxy.custom}");
        System.setProperty("PROXY_BASE_URL_HEADERS", "true");
        try {
            GeoServerEnvironment.reloadAllowEnvParametrization();
            CaseInsensitiveMap headers = new CaseInsensitiveMap(new HashMap());
            headers.put("X-Forwarded-Proto", "https");
            headers.put("X-Forwarded-Host", "www.altavista.com");
            HTTPHeadersCollector.HEADERS.set(headers);
            String url = ResponseUtils.buildURL((String)BASEURL, (String)"test", null, (URLMangler.URLType)URLMangler.URLType.SERVICE);
            Assert.assertEquals((Object)"https://www.altavista.com/http://custom.host/test", (Object)url);
        }
        finally {
            System.clearProperty("PROXY_BASE_URL");
            System.clearProperty("PROXY_BASE_URL_HEADERS");
            GeoServerEnvironment.reloadAllowEnvParametrization();
        }
    }

    @Test
    public void testProxyBaseUrlSystemPropertyDisabled() {
        System.setProperty("PROXY_BASE_URL", "${X-Forwarded-Proto}://${X-Forwarded-Host}/${proxy.custom}");
        System.setProperty("PROXY_BASE_URL_HEADERS", "false");
        try {
            GeoServerEnvironment.reloadAllowEnvParametrization();
            CaseInsensitiveMap headers = new CaseInsensitiveMap(new HashMap());
            headers.put("X-Forwarded-Proto", "https");
            headers.put("X-Forwarded-Host", "www.altavista.com");
            HTTPHeadersCollector.HEADERS.set(headers);
            String url = ResponseUtils.buildURL((String)BASEURL, (String)"test", null, (URLMangler.URLType)URLMangler.URLType.SERVICE);
            Assert.assertEquals((Object)"${X-Forwarded-Proto}://${X-Forwarded-Host}/http://custom.host/test", (Object)url);
        }
        finally {
            System.clearProperty("PROXY_BASE_URL");
            System.clearProperty("PROXY_BASE_URL_HEADERS");
            GeoServerEnvironment.reloadAllowEnvParametrization();
        }
    }
}

