/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows;

import java.util.HashMap;
import java.util.Map;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.ows.EnviromentInjectionCallback;
import org.geoserver.ows.Request;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Function;
import org.geotools.factory.CommonFactoryFinder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class EnvironmentInjectionCallbackTest
extends GeoServerSystemTestSupport {
    private static final FilterFactory FF = CommonFactoryFinder.getFilterFactory(null);
    private static final Function ENV_FUNCTION = FF.function("env", new Expression[]{FF.literal((Object)"GSUSER")});
    private static final EnviromentInjectionCallback CALLBACK = new EnviromentInjectionCallback();
    private Request request = null;

    @Override
    protected void setUpTestData(SystemTestData testData) throws Exception {
        testData.setUpSecurity();
    }

    @Before
    public void init() {
        this.request = new Request();
        this.request.setKvp(new HashMap());
    }

    @After
    public void clearLocalValues() {
        CALLBACK.finished(this.request);
        this.logout();
    }

    @Test
    public void testAnonymousWithoutEnv() throws Exception {
        CALLBACK.init(this.request);
        Assert.assertNull((Object)ENV_FUNCTION.evaluate(null));
    }

    @Test
    public void testAnonymousWithoutUserInEnv() throws Exception {
        this.request.getKvp().put("env", new HashMap());
        CALLBACK.init(this.request);
        Assert.assertNull((Object)ENV_FUNCTION.evaluate(null));
    }

    @Test
    public void testAnonymousWithUserInEnv() throws Exception {
        this.request.getKvp().put("env", new HashMap<String, String>(Map.of("GSUSER", "foo")));
        CALLBACK.init(this.request);
        Assert.assertNull((Object)ENV_FUNCTION.evaluate(null));
    }

    @Test
    public void testAdminWithoutEnv() throws Exception {
        this.loginAsAdmin();
        CALLBACK.init(this.request);
        Assert.assertEquals((Object)"admin", (Object)ENV_FUNCTION.evaluate(null));
    }

    @Test
    public void testAdminWithoutUserInEnv() throws Exception {
        this.loginAsAdmin();
        this.request.getKvp().put("env", new HashMap());
        CALLBACK.init(this.request);
        Assert.assertEquals((Object)"admin", (Object)ENV_FUNCTION.evaluate(null));
    }

    @Test
    public void testAdminWithUserInEnv() throws Exception {
        this.loginAsAdmin();
        this.request.getKvp().put("env", new HashMap<String, String>(Map.of("GSUSER", "foo")));
        CALLBACK.init(this.request);
        Assert.assertEquals((Object)"admin", (Object)ENV_FUNCTION.evaluate(null));
    }
}

