/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.logging;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Node;
import org.geoserver.logging.GeoServerXMLConfiguration;
import org.geoserver.logging.LoggingStartupContextListener;
import org.geoserver.logging.LoggingUtils;
import org.geoserver.logging.TestAppender;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.FileSystemResourceStore;
import org.geoserver.platform.resource.LockProvider;
import org.geoserver.platform.resource.MemoryLockProvider;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.springframework.mock.web.MockServletContext;

public class LoggingStartupContextListenerTest {
    static Locale systemLocale;

    @BeforeClass
    public static void initialize() {
        systemLocale = Locale.getDefault();
        Locale.setDefault(Locale.ENGLISH);
        System.clearProperty("RELINQUISH_LOG4J_CONTROL");
        LoggingUtils.relinquishLog4jControl = false;
    }

    @AfterClass
    public static void reset() {
        Locale.setDefault(systemLocale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateBuiltInLoggingProfile() throws Exception {
        boolean found;
        File TARGET_DIR = new File("./target");
        File LOGS_DIR = new File(TARGET_DIR, "logs");
        File DEFAULT_LOGGING_FILE = new File(LOGS_DIR, "DEFAULT_LOGGING.xml");
        FileUtils.deleteQuietly((File)LOGS_DIR);
        GeoServerResourceLoader loader = new GeoServerResourceLoader(TARGET_DIR);
        LoggingUtils.initLogging((GeoServerResourceLoader)loader, (String)"DEFAULT_LOGGING.xml", (boolean)false, (boolean)true, null);
        Assert.assertTrue((String)"DEFAULT_LOGGING.xml created", (boolean)DEFAULT_LOGGING_FILE.exists());
        try (FileWriter fileWriter = new FileWriter(DEFAULT_LOGGING_FILE, true);
             BufferedWriter buffered = new BufferedWriter(fileWriter);
             PrintWriter writer = new PrintWriter(buffered);){
            writer.println("# Hello World");
        }
        try (Stream<String> stream = Files.lines(Paths.get(DEFAULT_LOGGING_FILE.getPath(), new String[0]));){
            found = stream.anyMatch(lines -> lines.contains("# Hello World"));
            Assert.assertTrue((String)"default logging customized", (boolean)found);
        }
        try {
            LoggingUtils.updateBuiltInLoggingProfiles = true;
            LoggingUtils.initLogging((GeoServerResourceLoader)loader, (String)"DEFAULT_LOGGING.xml", (boolean)false, (boolean)true, null);
        }
        finally {
            LoggingUtils.updateBuiltInLoggingProfiles = false;
        }
        stream = Files.lines(Paths.get(DEFAULT_LOGGING_FILE.getPath(), new String[0]));
        try {
            found = stream.anyMatch(lines -> lines.contains("# Hello World"));
            Assert.assertFalse((String)"default logging customized", (boolean)found);
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    @Test
    public void testAvoidCustomizationOverwrite() throws Exception {
        File target = new File("./target/logs-customize");
        File logs = new File(target, "logs");
        FileUtils.deleteQuietly((File)logs);
        GeoServerResourceLoader loader = new GeoServerResourceLoader(target);
        FileSystemResourceStore store = (FileSystemResourceStore)loader.getResourceStore();
        store.setLockProvider((LockProvider)new MemoryLockProvider());
        LoggingUtils.initLogging((GeoServerResourceLoader)loader, (String)"VERBOSE_LOGGING.xml", (boolean)false, (boolean)false, null);
        File verbose = new File(logs, "VERBOSE_LOGGING.xml");
        String xml = FileUtils.readFileToString((File)verbose, (Charset)StandardCharsets.UTF_8);
        String xmlUpdated = xml.replace("trace", "debug");
        FileUtils.writeStringToFile((File)verbose, (String)xmlUpdated, (Charset)StandardCharsets.UTF_8);
        long lastModified = verbose.lastModified();
        LoggingUtils.initLogging((GeoServerResourceLoader)loader, (String)"VERBOSE_LOGGING.xml", (boolean)false, (boolean)false, null);
        try (TestAppender appender = TestAppender.createAppender("override-test", null);){
            appender.startRecording("org.geoserver.logging");
            Assert.assertEquals((long)lastModified, (long)verbose.lastModified());
            Logger logger = LogManager.getLogger((String)"org.geoserver.logging");
            logger.debug("Should appear");
            logger.trace("Should not appear");
            appender.stopRecording("org.geoserver.logging");
            appender.assertTrue("Should appear");
            appender.assertFalse("Should not appear");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLogLocationFromServletContext() throws Exception {
        File tmp = File.createTempFile("log", "tmp", new File("target"));
        tmp.delete();
        tmp.mkdirs();
        File logs = new File(tmp, "logs");
        Assert.assertTrue((boolean)logs.mkdirs());
        FileUtils.copyURLToFile((URL)LoggingStartupContextListenerTest.class.getResource("logging.xml"), (File)new File(tmp, "logging.xml"));
        MockServletContext context = new MockServletContext();
        context.setInitParameter("GEOSERVER_DATA_DIR", tmp.getPath());
        context.setInitParameter("GEOSERVER_LOG_LOCATION", new File(tmp, "foo.log").getAbsolutePath());
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration configuration = ctx.getConfiguration();
        Appender appender = configuration.getAppender("geoserverlogfile");
        Assert.assertNull((String)("Expected geoserverlogfile to be null.  But was: " + appender), (Object)appender);
        ctx.close();
        String restore = System.getProperty("RELINQUISH_LOG4J_CONTROL");
        try {
            System.setProperty("RELINQUISH_LOG4J_CONTROL", "false");
            new LoggingStartupContextListener().contextInitialized(new ServletContextEvent((ServletContext)context));
        }
        finally {
            if (restore == null) {
                System.getProperties().remove("RELINQUISH_LOG4J_CONTROL");
            } else {
                System.setProperty("RELINQUISH_LOG4J_CONTROL", restore);
            }
        }
        String expectedLogfile = new File(tmp, "foo.log").getCanonicalPath();
        LoggerContext ctx2 = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration configuration2 = ctx2.getConfiguration();
        if (configuration2.getProperties().containsKey("GEOSERVER_LOG_LOCATION")) {
            Assert.assertEquals((String)"Property logfile", (Object)expectedLogfile, configuration2.getProperties().get("GEOSERVER_LOG_LOCATION"));
            Appender appender2 = configuration2.getAppender("geoserverlogfile");
            Assert.assertNotNull((String)"geoserverlogfile expected", (Object)appender2);
            Assert.assertTrue((boolean)(appender2 instanceof RollingFileAppender));
            RollingFileAppender fileAppender = (RollingFileAppender)appender2;
            Assert.assertTrue((String)"fileName property substitution", (boolean)fileAppender.getFileName().contains("${GEOSERVER_LOG_LOCATION}"));
        } else {
            Appender appender3 = configuration2.getAppender("geoserverlogfile");
            Assert.assertNotNull((String)"geoserverlogfile expected", (Object)appender3);
            Assert.assertTrue((boolean)(appender3 instanceof RollingFileAppender));
            RollingFileAppender fileAppender = (RollingFileAppender)appender3;
            Assert.assertEquals((String)"fileName property substitution", (Object)expectedLogfile, (Object)fileAppender.getFileName());
        }
    }

    @Test
    public void testLogLocationFromEmptyContext() throws Exception {
        File tmp = File.createTempFile("log", "tmp", new File("target"));
        tmp.delete();
        tmp.mkdirs();
        File logs = new File(tmp, "logs");
        Assert.assertTrue((boolean)logs.mkdirs());
        MockServletContext context = new MockServletContext();
        context.setInitParameter("GEOSERVER_DATA_DIR", tmp.getPath());
        context.setInitParameter("GEOSERVER_LOG_LOCATION", new File(tmp, "foo.log").getAbsolutePath());
        try (TestAppender appender = TestAppender.createAppender("quite", null);){
            appender.startRecording("org.geoserver.logging");
            appender.trigger("Could not reconfigure LOG4J loggers");
            LoggingStartupContextListener listener = new LoggingStartupContextListener();
            listener.contextInitialized(new ServletContextEvent((ServletContext)context));
            listener.contextDestroyed(new ServletContextEvent((ServletContext)context));
            appender.stopRecording("org.geoserver.logging");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInitLoggingLock() throws Exception {
        File TARGET_DIR = new File("./target");
        File LOGS_DIR = new File(TARGET_DIR, "logs");
        File DEFAULT_LOGGING_FILE = new File(LOGS_DIR, "DEFAULT_LOGGING.xml");
        FileUtils.deleteQuietly((File)LOGS_DIR);
        GeoServerResourceLoader loader = new GeoServerResourceLoader(TARGET_DIR);
        FileSystemResourceStore store = (FileSystemResourceStore)loader.getResourceStore();
        store.setLockProvider((LockProvider)new MemoryLockProvider());
        LoggingUtils.initLogging((GeoServerResourceLoader)loader, (String)"DEFAULT_LOGGING.xml", (boolean)false, (boolean)true, null);
        Assert.assertTrue((String)"DEFAULT_LOGGING.xml created", (boolean)DEFAULT_LOGGING_FILE.exists());
        LoggingUtils.initLogging((GeoServerResourceLoader)loader, (String)"DEFAULT_LOGGING.xml", (boolean)false, (boolean)true, null);
        LoggingUtils.initLogging((GeoServerResourceLoader)loader, (String)"DEFAULT_LOGGING.xml", (boolean)false, (boolean)true, null);
        try (FileWriter fileWriter = new FileWriter(DEFAULT_LOGGING_FILE, true);
             BufferedWriter buffered = new BufferedWriter(fileWriter);
             PrintWriter writer = new PrintWriter(buffered);){
            writer.println("# Hello World");
        }
        try (Stream<String> stream = Files.lines(Paths.get(DEFAULT_LOGGING_FILE.getPath(), new String[0]));){
            boolean found = stream.anyMatch(lines -> lines.contains("# Hello World"));
            Assert.assertTrue((String)"default logging customized", (boolean)found);
        }
        try {
            System.getProperties().put("UPDATE_BUILT_IN_LOGGING_PROFILES", "true");
            LoggingUtils.initLogging((GeoServerResourceLoader)loader, (String)"DEFAULT_LOGGING.xml", (boolean)false, (boolean)true, null);
        }
        finally {
            System.getProperties().remove("UPDATE_BUILT_IN_LOGGING_PROFILES");
        }
    }

    @Test
    public void testFilenameAndFilePattern() throws Exception {
        Assert.assertEquals((Object)"some/where/logging.txt", (Object)GeoServerXMLConfiguration.applyPathTemplate((String)"some/where/logging.txt", (String)"logs/geoserver.log"));
        Assert.assertEquals((Object)"some/where/logging-%d{MM-dd-yyyy}.log", (Object)GeoServerXMLConfiguration.applyPathTemplate((String)"some/where/logging", (String)"logs/geoserver-%d{MM-dd-yyyy}.log"));
        Assert.assertEquals((Object)"some/where/logging-%i.txt.zip", (Object)GeoServerXMLConfiguration.applyPathTemplate((String)"some/where/logging.txt", (String)"logs/geoserver-%i.log.zip"));
        Assert.assertEquals((Object)"some/where/logging-%d{MM-dd-yyyy}.txt.zip", (Object)GeoServerXMLConfiguration.applyPathTemplate((String)"some/where/logging.txt", (String)"logs/geoserver-%d{MM-dd-yyyy}.log.zip"));
        Assert.assertEquals((Object)"some/where/logging$hostName.txt", (Object)GeoServerXMLConfiguration.applyPathTemplate((String)"some/where/logging.txt", (String)"logs/$hostName.log"));
        Assert.assertEquals((Object)"some/where/logging-$hostName-%i.txt", (Object)GeoServerXMLConfiguration.applyPathTemplate((String)"some/where/logging.txt", (String)"logs/geoserver-$hostName-%i.log"));
        Assert.assertEquals((Object)"logs/geoserver.log", (Object)GeoServerXMLConfiguration.applyPathTemplate((String)"${baseDir}/logs/logging.log", (String)"logs/geoserver.log"));
    }

    @Test
    public void testNodeAttributes() {
        Node node = new Node();
        node.getAttributes().put("fileName", "logs/geoserver.log");
        Assert.assertNotNull((String)"attribute name lookup", (Object)GeoServerXMLConfiguration.attributeGet((Node)node, (String)"fileName"));
        Assert.assertNotNull((String)"attribute case-insensitive lookup", (Object)GeoServerXMLConfiguration.attributeGet((Node)node, (String)"filename"));
        Assert.assertEquals((String)"attribute style", (Object)"logs/geoserver.log", (Object)GeoServerXMLConfiguration.attributeGet((Node)node, (String)"fileName"));
        Assert.assertEquals((String)"element style", (Object)"logs/geoserver.log", (Object)GeoServerXMLConfiguration.attributeGet((Node)node, (String)"FileName"));
        Assert.assertEquals((String)"quick style", (Object)"logs/geoserver.log", (Object)GeoServerXMLConfiguration.attributeGet((Node)node, (String)"filename"));
        node.getAttributes().remove("fileName");
        Assert.assertNull((String)"attribute style", (Object)GeoServerXMLConfiguration.attributeGet((Node)node, (String)"fileName"));
        Assert.assertNull((String)"element style", (Object)GeoServerXMLConfiguration.attributeGet((Node)node, (String)"FileName"));
        Assert.assertNull((String)"quick style", (Object)GeoServerXMLConfiguration.attributeGet((Node)node, (String)"filename"));
        GeoServerXMLConfiguration.attributePut((Node)node, (String)"filename", (String)"history.txt");
        Assert.assertEquals((String)"store direct", (Object)"history.txt", node.getAttributes().get("filename"));
        GeoServerXMLConfiguration.attributePut((Node)node, (String)"fileName", (String)"geoserver.log");
        Assert.assertEquals((String)"store match", (Object)"geoserver.log", node.getAttributes().get("filename"));
    }

    @Test
    public void testDateFormat() throws Exception {
        File target = new File("./target/logs-date");
        File logs = new File(target, "logs");
        FileUtils.deleteQuietly((File)logs);
        logs.mkdir();
        GeoServerResourceLoader loader = new GeoServerResourceLoader(target);
        LoggingStartupContextListenerTest.testExpectetFormat(loader, "DEFAULT_LOGGING");
        LoggingStartupContextListenerTest.testExpectetFormat(loader, "GEOSERVER_DEVELOPER_LOGGING");
        LoggingStartupContextListenerTest.testExpectetFormat(loader, "PRODUCTION_LOGGING");
        LoggingStartupContextListenerTest.testExpectetFormat(loader, "VERBOSE_LOGGING");
        LoggingStartupContextListenerTest.testExpectetFormat(loader, "GEOTOOLS_DEVELOPER_LOGGING");
        LoggingUtils.initLogging((GeoServerResourceLoader)loader, (String)"TEST_LOGGING", (boolean)true, (boolean)true, null);
    }

    private static void testExpectetFormat(GeoServerResourceLoader loader, String configuration) throws Exception {
        String location = "logs/" + configuration + ".log";
        LoggingUtils.initLogging((GeoServerResourceLoader)loader, (String)configuration, (boolean)true, (boolean)false, (String)location);
        Logger logger = LogManager.getLogger((String)"org.geoserver.logging");
        logger.error("Test message");
        File logFile = new File(loader.getBaseDirectory(), location);
        String contents = FileUtils.readFileToString((File)logFile, (Charset)StandardCharsets.UTF_8);
        Pattern pattern = Pattern.compile("\\d{2} \\w{3} \\d{2}:\\d{2}:\\d{2}.*", 32);
        Assert.assertTrue((boolean)pattern.matcher(contents).matches());
    }
}

