/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.filters;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.config.util.XStreamPersisterFactory;
import org.geoserver.filters.SecurityHeadersFilter;
import org.geoserver.platform.GeoServerExtensionsHelper;
import org.geoserver.security.csp.CSPConfiguration;
import org.geoserver.security.csp.CSPHeaderDAO;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.springframework.mock.web.MockFilterChain;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

public class SecurityHeadersFilterTest {
    @ClassRule
    public static TemporaryFolder folder = new TemporaryFolder();
    private static CSPHeaderDAO dao;

    @BeforeClass
    public static void initDAO() throws IOException {
        GeoServerDataDirectory dd = new GeoServerDataDirectory(folder.getRoot());
        XStreamPersisterFactory xpf = new XStreamPersisterFactory();
        dao = new CSPHeaderDAO(null, dd, xpf);
        GeoServerExtensionsHelper.singleton("cspHeaderDAO", dao, new Class[0]);
    }

    @AfterClass
    public static void clearExtensions() {
        GeoServerExtensionsHelper.clear();
    }

    @Before
    @After
    public void resetProperties() {
        System.clearProperty("geoserver.xContentType.shouldSetPolicy");
        System.clearProperty("geoserver.hsts.policy");
        System.clearProperty("geoserver.hsts.shouldSetPolicy");
        System.clearProperty("geoserver.xframe.policy");
        System.clearProperty("geoserver.xframe.shouldSetPolicy");
        System.clearProperty("geoserver.xXssProtection.policy");
        System.clearProperty("geoserver.xXssProtection.shouldSetPolicy");
    }

    @Test
    public void testFilterCSPDisabled() throws Exception {
        SecurityHeadersFilterTest.setCSPConfig(false, true);
        Assert.assertNull((Object)SecurityHeadersFilterTest.getHeader("Content-Security-Policy"));
        Assert.assertNull((Object)SecurityHeadersFilterTest.getHeader("Content-Security-Policy-Report-Only"));
    }

    @Test
    public void testFilterCSPBlocking() throws Exception {
        SecurityHeadersFilterTest.setCSPConfig(true, false);
        String expected = "base-uri 'self'; form-action 'self'; default-src 'none'; child-src 'self'; connect-src 'self'; font-src 'self'; img-src 'self' data:; style-src 'self' 'unsafe-inline'; script-src 'self';, frame-ancestors 'self';";
        Assert.assertEquals((Object)expected, (Object)SecurityHeadersFilterTest.getHeader("Content-Security-Policy"));
        Assert.assertNull((Object)SecurityHeadersFilterTest.getHeader("Content-Security-Policy-Report-Only"));
    }

    @Test
    public void testFilterCSPReporting() throws Exception {
        SecurityHeadersFilterTest.setCSPConfig(true, true);
        String expected = "base-uri 'self'; form-action 'self'; default-src 'none'; child-src 'self'; connect-src 'self'; font-src 'self'; img-src 'self' data:; style-src 'self' 'unsafe-inline'; script-src 'self';, frame-ancestors 'self';";
        Assert.assertNull((Object)SecurityHeadersFilterTest.getHeader("Content-Security-Policy"));
        Assert.assertEquals((Object)expected, (Object)SecurityHeadersFilterTest.getHeader("Content-Security-Policy-Report-Only"));
    }

    private static void setCSPConfig(boolean enabled, boolean reportOnly) throws Exception {
        CSPConfiguration config = dao.getConfig();
        config.setEnabled(enabled);
        config.setReportOnly(reportOnly);
        dao.setConfig(config);
    }

    @Test
    public void testFilterDefaultFrameOptions() throws Exception {
        Assert.assertEquals((Object)"SAMEORIGIN", (Object)SecurityHeadersFilterTest.getHeader("X-Frame-Options"));
    }

    @Test
    public void testFilterWithoutFrameOptions() throws Exception {
        System.setProperty("geoserver.xframe.shouldSetPolicy", "false");
        Assert.assertNull((Object)SecurityHeadersFilterTest.getHeader("X-Frame-Options"));
    }

    @Test
    public void testFilterCustomFrameOptions() throws Exception {
        System.setProperty("geoserver.xframe.policy", "DENY");
        Assert.assertEquals((Object)"DENY", (Object)SecurityHeadersFilterTest.getHeader("X-Frame-Options"));
    }

    @Test
    public void testFilterDefaultContentTypeOptions() throws Exception {
        Assert.assertEquals((Object)"nosniff", (Object)SecurityHeadersFilterTest.getHeader("X-Content-Type-Options"));
    }

    @Test
    public void testFilterWithoutContentTypeOptions() throws Exception {
        System.setProperty("geoserver.xContentType.shouldSetPolicy", "false");
        Assert.assertNull((Object)SecurityHeadersFilterTest.getHeader("X-Content-Type-Options"));
    }

    @Test
    public void testFilterDefaultXssProtection() throws Exception {
        Assert.assertNull((Object)SecurityHeadersFilterTest.getHeader("X-XSS-Protection"));
    }

    @Test
    public void testFilterWithXssProtection() throws Exception {
        System.setProperty("geoserver.xXssProtection.shouldSetPolicy", "true");
        Assert.assertEquals((Object)"0", (Object)SecurityHeadersFilterTest.getHeader("X-XSS-Protection"));
    }

    @Test
    public void testFilterCustomXssProtection() throws Exception {
        System.setProperty("geoserver.xXssProtection.shouldSetPolicy", "true");
        System.setProperty("geoserver.xXssProtection.policy", "1; mode=block");
        Assert.assertEquals((Object)"1; mode=block", (Object)SecurityHeadersFilterTest.getHeader("X-XSS-Protection"));
    }

    @Test
    public void testFilterHttpHstsDefault() throws Exception {
        Assert.assertNull((Object)SecurityHeadersFilterTest.getHeader("Strict-Transport-Security"));
    }

    @Test
    public void testFilterHttpHstsEnabled() throws Exception {
        System.setProperty("geoserver.hsts.shouldSetPolicy", "true");
        Assert.assertNull((Object)SecurityHeadersFilterTest.getHeader("Strict-Transport-Security"));
    }

    @Test
    public void testFilterHttpsHstsDefault() throws Exception {
        Assert.assertNull((Object)SecurityHeadersFilterTest.getHeader(true, "Strict-Transport-Security"));
    }

    @Test
    public void testFilterHttpsHstsEnabled() throws Exception {
        System.setProperty("geoserver.hsts.shouldSetPolicy", "true");
        Assert.assertEquals((Object)"max-age=31536000 ; includeSubDomains", (Object)SecurityHeadersFilterTest.getHeader(true, "Strict-Transport-Security"));
    }

    @Test
    public void testFilterHttpsHstsCustom() throws Exception {
        System.setProperty("geoserver.hsts.shouldSetPolicy", "true");
        System.setProperty("geoserver.hsts.policy", "max-age=985500");
        Assert.assertEquals((Object)"max-age=985500", (Object)SecurityHeadersFilterTest.getHeader(true, "Strict-Transport-Security"));
    }

    private static String getHeader(String name) throws Exception {
        return SecurityHeadersFilterTest.getHeader(false, name);
    }

    private static String getHeader(boolean secure, String name) throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest("GET", "");
        request.setScheme(secure ? "https" : "http");
        MockHttpServletResponse response = new MockHttpServletResponse();
        SecurityHeadersFilter filter = new SecurityHeadersFilter();
        MockFilterChain mockChain = new MockFilterChain();
        filter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)mockChain);
        return response.getHeader(name);
    }
}

